/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth.data;

import org.apache.cxf.rs.security.oauth.data.AccessToken;

public class Client {
    private String consumerKey;
    private String secretKey;
    private String applicationURI;
    private String applicationName;
    private String applicationDescription;
    private String logoUri;
    private String callbackURI;
    private String loginName;
    private AccessToken preAuthorizedToken;

    public Client(String consumerId, String secretKey, String applicationName, String applicationURI) {
        this.consumerKey = consumerId;
        this.secretKey = secretKey;
        this.applicationURI = applicationURI;
        this.applicationName = applicationName;
    }

    public Client(String consumerId, String secretKey) {
        this(consumerId, secretKey, null, null);
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationURI() {
        return this.applicationURI;
    }

    public void setApplicationURI(String applicationURI) {
        this.applicationURI = applicationURI;
    }

    public void setApplicationDescription(String applicationDescription) {
        this.applicationDescription = applicationDescription;
    }

    public String getApplicationDescription() {
        return this.applicationDescription;
    }

    public void setLogoUri(String logoPath) {
        this.logoUri = logoPath;
    }

    public String getLogoUri() {
        return this.logoUri;
    }

    public String getLoginName() {
        return this.loginName == null ? this.consumerKey : this.loginName;
    }

    public void setLoginName(String name) {
        this.loginName = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Client that = (Client)o;
        if (!this.consumerKey.equals(that.consumerKey)) {
            return false;
        }
        return this.secretKey.equals(that.secretKey);
    }

    public int hashCode() {
        int result = this.consumerKey.hashCode();
        result = 31 * result + this.secretKey.hashCode();
        return result;
    }

    public void setPreAuthorizedToken(AccessToken preAuthorizedToken) {
        this.preAuthorizedToken = preAuthorizedToken;
    }

    public AccessToken getPreAuthorizedToken() {
        return this.preAuthorizedToken;
    }

    public void setCallbackURI(String callbackURI) {
        this.callbackURI = callbackURI;
    }

    public String getCallbackURI() {
        return this.callbackURI;
    }
}

