/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public class PublicKeyJwsSignatureVerifier
implements JwsSignatureVerifier {
    protected static final Logger LOG = LogUtils.getL7dLogger(PublicKeyJwsSignatureVerifier.class);
    private PublicKey key;
    private AlgorithmParameterSpec signatureSpec;
    private SignatureAlgorithm supportedAlgo;
    private X509Certificate cert;

    public PublicKeyJwsSignatureVerifier(PublicKey key, SignatureAlgorithm supportedAlgorithm) {
        this(key, null, supportedAlgorithm);
    }

    public PublicKeyJwsSignatureVerifier(PublicKey key, AlgorithmParameterSpec spec, SignatureAlgorithm supportedAlgo) {
        this.key = key;
        this.signatureSpec = spec;
        this.supportedAlgo = supportedAlgo;
        JwsUtils.checkSignatureKeySize(key);
    }

    public PublicKeyJwsSignatureVerifier(X509Certificate cert, SignatureAlgorithm supportedAlgorithm) {
        this(cert, null, supportedAlgorithm);
    }

    public PublicKeyJwsSignatureVerifier(X509Certificate cert, AlgorithmParameterSpec spec, SignatureAlgorithm supportedAlgo) {
        if (cert != null) {
            this.key = cert.getPublicKey();
        }
        this.cert = cert;
        this.signatureSpec = spec;
        this.supportedAlgo = supportedAlgo;
        JwsUtils.checkSignatureKeySize(this.key);
    }

    @Override
    public boolean verify(JwsHeaders headers, String unsignedText, byte[] signature) {
        try {
            return CryptoUtils.verifySignature((byte[])StringUtils.toBytesUTF8((String)unsignedText), (byte[])signature, (PublicKey)this.key, (String)AlgorithmUtils.toJavaName(this.checkAlgorithm(headers.getSignatureAlgorithm())), (AlgorithmParameterSpec)this.signatureSpec);
        }
        catch (Exception ex) {
            LOG.warning("Invalid signature: " + ex.getMessage());
            throw new JwsException(JwsException.Error.INVALID_SIGNATURE, (Throwable)ex);
        }
    }

    protected String checkAlgorithm(SignatureAlgorithm sigAlgo) {
        String algo = sigAlgo.getJwaName();
        if (algo == null) {
            LOG.warning("Signature algorithm is not set");
            throw new JwsException(JwsException.Error.ALGORITHM_NOT_SET);
        }
        if (!this.isValidAlgorithmFamily(algo) || !algo.equals(this.supportedAlgo.getJwaName())) {
            LOG.warning("Invalid signature algorithm: " + algo);
            throw new JwsException(JwsException.Error.INVALID_ALGORITHM);
        }
        return algo;
    }

    protected boolean isValidAlgorithmFamily(String algo) {
        return AlgorithmUtils.isRsaSign(algo);
    }

    @Override
    public SignatureAlgorithm getAlgorithm() {
        return this.supportedAlgo;
    }

    public X509Certificate getX509Certificate() {
        return this.cert;
    }
}

