/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;

public class NoneJwsSignatureProvider
implements JwsSignatureProvider {
    @Override
    public SignatureAlgorithm getAlgorithm() {
        return SignatureAlgorithm.NONE;
    }

    @Override
    public JwsSignature createJwsSignature(JwsHeaders headers) {
        return new NoneJwsSignature();
    }

    @Override
    public byte[] sign(JwsHeaders headers, byte[] content) {
        JwsSignature sig = this.createJwsSignature(headers);
        sig.update(content, 0, content.length);
        return sig.sign();
    }

    private static class NoneJwsSignature
    implements JwsSignature {
        private NoneJwsSignature() {
        }

        @Override
        public void update(byte[] src, int off, int len) {
        }

        @Override
        public byte[] sign() {
            return new byte[0];
        }
    }
}

