/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.common;

import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public abstract class AbstractJoseProducer {
    private JwsSignatureProvider sigProvider;
    private JweEncryptionProvider encryptionProvider;

    protected JwsSignatureProvider getInitializedSignatureProvider(JwsHeaders jwsHeaders) {
        if (this.sigProvider != null) {
            return this.sigProvider;
        }
        return JwsUtils.loadSignatureProvider(jwsHeaders, false);
    }

    protected JweEncryptionProvider getInitializedEncryptionProvider(JweHeaders jweHeaders) {
        if (this.encryptionProvider != null) {
            return this.encryptionProvider;
        }
        return JweUtils.loadEncryptionProvider(jweHeaders, false);
    }

    public void setEncryptionProvider(JweEncryptionProvider encryptionProvider) {
        this.encryptionProvider = encryptionProvider;
    }

    public void setSignatureProvider(JwsSignatureProvider signatureProvider) {
        this.sigProvider = signatureProvider;
    }
}

