/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.cxf.common.util.Base64UrlOutputStream;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJwsJsonWriterProvider;
import org.apache.cxf.rs.security.jose.jaxrs.JoseJaxrsUtils;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsJsonOutputStream;
import org.apache.cxf.rs.security.jose.jws.JwsJsonProducer;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;

@Priority(value=1002)
public class JwsJsonWriterInterceptor
extends AbstractJwsJsonWriterProvider
implements WriterInterceptor {
    private Set<String> protectedHttpHeaders;
    private boolean protectHttpHeaders;
    private JsonMapObjectReaderWriter writer = new JsonMapObjectReaderWriter();
    private boolean contentTypeRequired = true;
    private boolean useJwsOutputStream;
    private boolean encodePayload = true;

    public void aroundWriteTo(WriterInterceptorContext ctx) throws IOException, WebApplicationException {
        if (ctx.getEntity() == null) {
            ctx.proceed();
            return;
        }
        List<String> propLocs = this.getPropertyLocations();
        ArrayList<JwsHeaders> protectedHeaders = new ArrayList<JwsHeaders>(propLocs.size());
        for (int i = 0; i < propLocs.size(); ++i) {
            protectedHeaders.add(new JwsHeaders());
        }
        List<JwsSignatureProvider> sigProviders = this.getInitializedSigProviders(propLocs, protectedHeaders);
        OutputStream actualOs = ctx.getOutputStream();
        if (this.useJwsOutputStream) {
            ArrayList<String> encodedProtectedHeaders = new ArrayList<String>(sigProviders.size());
            ArrayList<JwsSignature> signatures = new ArrayList<JwsSignature>(sigProviders.size());
            int size = sigProviders.size();
            for (int i = 0; i < size; ++i) {
                JwsSignatureProvider signer = sigProviders.get(i);
                JwsHeaders protectedHeader = (JwsHeaders)protectedHeaders.get(i);
                this.prepareProtectedHeader(protectedHeader, ctx, signer, size == 1);
                String encoded = Base64UrlUtility.encode((String)this.writer.toJson((JsonMapObject)protectedHeader));
                encodedProtectedHeaders.add(encoded);
                JwsSignature signature = signer.createJwsSignature(protectedHeader);
                byte[] start = StringUtils.toBytesUTF8((String)(encoded + "."));
                signature.update(start, 0, start.length);
                signatures.add(signature);
            }
            ctx.setMediaType(JAXRSUtils.toMediaType((String)"application/jose+json"));
            actualOs.write(StringUtils.toBytesUTF8((String)"{\"payload\":\""));
            JwsJsonOutputStream jwsStream = new JwsJsonOutputStream(actualOs, encodedProtectedHeaders, signatures);
            Base64UrlOutputStream base64Stream = null;
            if (this.encodePayload) {
                base64Stream = new Base64UrlOutputStream((OutputStream)jwsStream);
                ctx.setOutputStream((OutputStream)base64Stream);
            } else {
                ctx.setOutputStream((OutputStream)jwsStream);
            }
            ctx.proceed();
            if (base64Stream != null) {
                base64Stream.flush();
            }
            jwsStream.flush();
        } else {
            CachedOutputStream cos = new CachedOutputStream();
            ctx.setOutputStream((OutputStream)cos);
            ctx.proceed();
            JwsJsonProducer p = new JwsJsonProducer(new String(cos.getBytes(), StandardCharsets.UTF_8));
            int size = sigProviders.size();
            for (int i = 0; i < size; ++i) {
                JwsSignatureProvider signer = sigProviders.get(i);
                JwsHeaders protectedHeader = (JwsHeaders)protectedHeaders.get(i);
                this.prepareProtectedHeader(protectedHeader, ctx, signer, size == 1);
                p.signWith(signer, protectedHeader, null);
            }
            ctx.setMediaType(JAXRSUtils.toMediaType((String)"application/jose+json"));
            this.writeJws(p, actualOs);
        }
    }

    private void prepareProtectedHeader(JwsHeaders headers, WriterInterceptorContext ctx, JwsSignatureProvider signer, boolean protectHttp) {
        headers.setSignatureAlgorithm(signer.getAlgorithm());
        this.setContentTypeIfNeeded((JoseHeaders)headers, ctx);
        if (!this.encodePayload) {
            headers.setPayloadEncodingStatus(Boolean.valueOf(false));
        }
        if (protectHttp) {
            this.protectHttpHeadersIfNeeded(ctx, headers);
        }
    }

    public void setContentTypeRequired(boolean contentTypeRequired) {
        this.contentTypeRequired = contentTypeRequired;
    }

    public void setUseJwsJsonOutputStream(boolean useJwsJsonOutputStream) {
        this.useJwsOutputStream = useJwsJsonOutputStream;
    }

    private void setContentTypeIfNeeded(JoseHeaders headers, WriterInterceptorContext ctx) {
        MediaType mt;
        if (this.contentTypeRequired && (mt = ctx.getMediaType()) != null && !JAXRSUtils.mediaTypeToString((MediaType)mt, (String[])new String[0]).equals("application/jose+json")) {
            if ("application".equals(mt.getType())) {
                headers.setContentType(mt.getSubtype());
            } else {
                headers.setContentType(JAXRSUtils.mediaTypeToString((MediaType)mt, (String[])new String[0]));
            }
        }
    }

    public void setEncodePayload(boolean encodePayload) {
        this.encodePayload = encodePayload;
    }

    protected void protectHttpHeadersIfNeeded(WriterInterceptorContext ctx, JwsHeaders jwsHeaders) {
        if (this.protectHttpHeaders) {
            JoseJaxrsUtils.protectHttpHeaders((MultivaluedMap<String, Object>)ctx.getHeaders(), (JoseHeaders)jwsHeaders, this.protectedHttpHeaders);
        }
    }

    public void setProtectHttpHeaders(boolean protectHttpHeaders) {
        this.protectHttpHeaders = protectHttpHeaders;
    }

    public void setProtectedHttpHeaders(Set<String> protectedHttpHeaders) {
        this.protectedHttpHeaders = protectedHttpHeaders;
    }
}

