/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJweDecryptingFilter;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;

@PreMatching
@Priority(value=1001)
public class JweContainerRequestFilter
extends AbstractJweDecryptingFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext context) throws IOException {
        if ("GET".equals(context.getMethod())) {
            return;
        }
        JweDecryptionOutput out = this.decrypt(context.getEntityStream());
        byte[] bytes = out.getContent();
        context.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
        context.getHeaders().putSingle((Object)"Content-Length", (Object)Integer.toString(bytes.length));
        String ct = JoseUtils.checkContentType((String)out.getHeaders().getContentType(), (String)this.getDefaultMediaType());
        if (ct != null) {
            context.getHeaders().putSingle((Object)"Content-Type", (Object)ct);
        }
    }
}

