/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.cdi;

import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxrs.impl.ConfigurableImpl;
import org.apache.cxf.microprofile.client.cdi.CDIInstantiator;
import org.apache.cxf.microprofile.client.cdi.CDIUtils;
import org.apache.cxf.microprofile.client.cdi.Instance;

public final class CDIFacade {
    private static final boolean CDI_AVAILABLE;

    private CDIFacade() {
    }

    public static Optional<Object> getBeanManager(Bus b) {
        return CDIFacade.nullableOptional(() -> CDIUtils.getCurrentBeanManager(b));
    }

    public static Optional<Object> getBeanManager() {
        try {
            return CDIFacade.nullableOptional(() -> CDIUtils.getCurrentBeanManager());
        }
        catch (Throwable t) {
            t.printStackTrace();
            return Optional.ofNullable(null);
        }
    }

    public static <T> Optional<Instance<T>> getInstanceFromCDI(Class<T> clazz, Bus b) {
        return CDIFacade.nullableOptional(() -> CDIUtils.getInstanceFromCDI(clazz, b));
    }

    public static <T> Optional<Instance<T>> getInstanceFromCDI(Class<T> clazz) {
        return CDIFacade.nullableOptional(() -> CDIUtils.getInstanceFromCDI(clazz));
    }

    public static Optional<ConfigurableImpl.Instantiator> getInstantiator() {
        return Optional.ofNullable(CDI_AVAILABLE ? CDIInstantiator.INSTANCE : null);
    }

    private static <T> Optional<T> nullableOptional(Callable<T> callable) {
        T t;
        if (!CDI_AVAILABLE) {
            return Optional.empty();
        }
        try {
            t = callable.call();
        }
        catch (Throwable ex) {
            t = null;
        }
        return Optional.ofNullable(t);
    }

    static {
        boolean b;
        try {
            Class.forName("javax.enterprise.inject.spi.BeanManager");
            b = true;
        }
        catch (Throwable t) {
            b = false;
        }
        CDI_AVAILABLE = b;
    }
}

