/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.tika;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.ToTextContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TikaContentExtractor {
    private static final Logger LOG = LogUtils.getL7dLogger(TikaContentExtractor.class);
    private final List<Parser> parsers;
    private final Detector detector;

    public TikaContentExtractor(Parser parser) {
        this(parser, true);
    }

    public TikaContentExtractor(List<Parser> parsers) {
        this(parsers, (Detector)new DefaultDetector());
    }

    public TikaContentExtractor(List<Parser> parsers, Detector detector) {
        this.parsers = parsers;
        this.detector = detector;
    }

    public TikaContentExtractor(Parser parser, boolean validateMediaType) {
        this(Collections.singletonList(parser), (Detector)(validateMediaType ? new DefaultDetector() : null));
    }

    public TikaContent extract(InputStream in) {
        return this.extract(in, true);
    }

    public TikaContent extractMetadata(InputStream in) {
        return this.extract(in, false);
    }

    public SearchBean extractMetadataToSearchBean(InputStream in) {
        TikaContent tc = this.extractMetadata(in);
        if (tc == null) {
            return null;
        }
        Metadata metadata = tc.getMetadata();
        SearchBean bean = new SearchBean();
        for (String property : metadata.names()) {
            bean.set(property, metadata.get(property));
        }
        return bean;
    }

    public TikaContent extract(InputStream in, ContentHandler handler) {
        return this.extract(in, handler, null);
    }

    public TikaContent extract(InputStream in, ContentHandler handler, ParseContext context) {
        if (in == null) {
            return null;
        }
        try {
            Metadata metadata = new Metadata();
            MediaType mediaType = null;
            Parser parser = null;
            for (Parser p : this.parsers) {
                if (this.detector != null) {
                    mediaType = this.detector.detect(in, metadata);
                    if (mediaType == null || !p.getSupportedTypes(context).contains(mediaType)) continue;
                    parser = p;
                    break;
                }
                parser = p;
            }
            if (parser == null) {
                return null;
            }
            if (context == null) {
                context = new ParseContext();
            }
            parser.parse(in, handler, metadata, context);
            return new TikaContent(handler, metadata, mediaType);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Unable to extract media type from input stream", ex);
        }
        catch (SAXException ex) {
            LOG.log(Level.WARNING, "Unable to parse input stream", ex);
        }
        catch (TikaException ex) {
            LOG.log(Level.WARNING, "Unable to parse input stream", ex);
        }
        return null;
    }

    TikaContent extract(InputStream in, boolean extractContent) {
        ToTextContentHandler handler = extractContent ? new ToTextContentHandler() : new IgnoreContentHandler();
        return this.extract(in, (ContentHandler)handler, null);
    }

    private static class IgnoreContentHandler
    extends ToTextContentHandler {
        private IgnoreContentHandler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public String toString() {
            return "";
        }
    }

    public static class TikaContent {
        private ContentHandler contentHandler;
        private Metadata metadata;
        private MediaType mediaType;

        public TikaContent(ContentHandler contentHandler, Metadata metadata, MediaType mediaType) {
            this.contentHandler = contentHandler;
            this.metadata = metadata;
            this.mediaType = mediaType;
        }

        public String getContent() {
            return this.contentHandler.toString();
        }

        public Metadata getMetadata() {
            return this.metadata;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }
    }
}

