/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.rx2.server;

import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.disposables.Disposable;
import jakarta.ws.rs.container.AsyncResponse;
import java.util.Collections;
import org.apache.cxf.jaxrs.impl.AsyncResponseImpl;
import org.apache.cxf.jaxrs.reactivestreams.server.AbstractReactiveInvoker;
import org.apache.cxf.message.Message;
import org.reactivestreams.Publisher;

public class ReactiveIOInvoker
extends AbstractReactiveInvoker {
    protected AsyncResponseImpl checkFutureResponse(Message inMessage, Object result) {
        if (result instanceof Flowable) {
            return this.handleFlowable(inMessage, (Flowable)result);
        }
        if (result instanceof Single) {
            return this.handleSingle(inMessage, (Single)result);
        }
        if (result instanceof Observable) {
            return this.handleObservable(inMessage, (Observable)result);
        }
        if (result instanceof Maybe) {
            return this.handleMaybe(inMessage, (Maybe)result);
        }
        return null;
    }

    protected AsyncResponseImpl handleMaybe(Message inMessage, Maybe<?> maybe) {
        AsyncResponseImpl asyncResponse = new AsyncResponseImpl(inMessage);
        Disposable d = this.subscribe(maybe, asyncResponse);
        if (d == null) {
            throw new IllegalStateException("Subscribe did not return a Disposable");
        }
        return asyncResponse;
    }

    protected AsyncResponseImpl handleSingle(Message inMessage, Single<?> single) {
        AsyncResponseImpl asyncResponse = new AsyncResponseImpl(inMessage);
        Disposable d = single.subscribe(arg_0 -> ((AsyncResponseImpl)asyncResponse).resume(arg_0), t -> this.handleThrowable(asyncResponse, (Throwable)t));
        if (d == null) {
            throw new IllegalStateException("Subscribe did not return a Disposable");
        }
        return asyncResponse;
    }

    protected AsyncResponseImpl handleFlowable(Message inMessage, Flowable<?> f) {
        Disposable d;
        AsyncResponseImpl asyncResponse = new AsyncResponseImpl(inMessage);
        if (!this.isStreamingSubscriberUsed((Publisher)f, (AsyncResponse)asyncResponse, inMessage) && (d = this.subscribe(f, asyncResponse)) == null) {
            throw new IllegalStateException("Subscribe did not return a Disposable");
        }
        return asyncResponse;
    }

    protected AsyncResponseImpl handleObservable(Message inMessage, Observable<?> obs) {
        AsyncResponseImpl asyncResponse = new AsyncResponseImpl(inMessage);
        Disposable d = this.subscribe(obs, asyncResponse);
        if (d == null) {
            throw new IllegalStateException("Subscribe did not return a Disposable");
        }
        return asyncResponse;
    }

    private <T> Disposable subscribe(Flowable<T> f, AsyncResponseImpl asyncResponse) {
        return f.switchIfEmpty((Publisher)Flowable.empty().doOnComplete(() -> asyncResponse.resume(Collections.emptyList()))).subscribe(arg_0 -> ((AsyncResponseImpl)asyncResponse).resume(arg_0), t -> this.handleThrowable(asyncResponse, (Throwable)t));
    }

    private <T> Disposable subscribe(Observable<T> obs, AsyncResponseImpl asyncResponse) {
        return obs.switchIfEmpty((ObservableSource)Observable.empty().doOnComplete(() -> asyncResponse.resume(Collections.emptyList()))).subscribe(arg_0 -> ((AsyncResponseImpl)asyncResponse).resume(arg_0), t -> this.handleThrowable(asyncResponse, (Throwable)t));
    }

    private <T> Disposable subscribe(Maybe<T> maybe, AsyncResponseImpl asyncResponse) {
        return maybe.switchIfEmpty((MaybeSource)Maybe.empty().doOnComplete(() -> asyncResponse.resume(null))).subscribe(arg_0 -> ((AsyncResponseImpl)asyncResponse).resume(arg_0), t -> this.handleThrowable(asyncResponse, (Throwable)t));
    }
}

