/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.rx2.client;

import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.SyncInvoker;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.rx2.client.ObservableRxInvoker;

public class ObservableRxInvokerImpl
implements ObservableRxInvoker {
    private Scheduler sc;
    private SyncInvoker syncInvoker;

    public ObservableRxInvokerImpl(SyncInvoker syncInvoker, ExecutorService ex) {
        this.syncInvoker = syncInvoker;
        this.sc = ex == null ? null : Schedulers.from((Executor)ex);
    }

    @Override
    public Observable<Response> get() {
        return this.get(Response.class);
    }

    @Override
    public <T> Observable<T> get(Class<T> responseType) {
        return this.method("GET", responseType);
    }

    @Override
    public <T> Observable<T> get(GenericType<T> responseType) {
        return this.method("GET", responseType);
    }

    @Override
    public Observable<Response> put(Entity<?> entity) {
        return this.put(entity, Response.class);
    }

    @Override
    public <T> Observable<T> put(Entity<?> entity, Class<T> responseType) {
        return this.method("PUT", entity, responseType);
    }

    @Override
    public <T> Observable<T> put(Entity<?> entity, GenericType<T> responseType) {
        return this.method("PUT", entity, responseType);
    }

    @Override
    public Observable<Response> post(Entity<?> entity) {
        return this.post(entity, Response.class);
    }

    @Override
    public <T> Observable<T> post(Entity<?> entity, Class<T> responseType) {
        return this.method("POST", entity, responseType);
    }

    @Override
    public <T> Observable<T> post(Entity<?> entity, GenericType<T> responseType) {
        return this.method("POST", entity, responseType);
    }

    @Override
    public Observable<Response> delete() {
        return this.delete(Response.class);
    }

    @Override
    public <T> Observable<T> delete(Class<T> responseType) {
        return this.method("DELETE", responseType);
    }

    @Override
    public <T> Observable<T> delete(GenericType<T> responseType) {
        return this.method("DELETE", responseType);
    }

    @Override
    public Observable<Response> head() {
        return this.method("HEAD");
    }

    @Override
    public Observable<Response> options() {
        return this.options(Response.class);
    }

    @Override
    public <T> Observable<T> options(Class<T> responseType) {
        return this.method("OPTIONS", responseType);
    }

    @Override
    public <T> Observable<T> options(GenericType<T> responseType) {
        return this.method("OPTIONS", responseType);
    }

    @Override
    public Observable<Response> trace() {
        return this.trace(Response.class);
    }

    @Override
    public <T> Observable<T> trace(Class<T> responseType) {
        return this.method("TRACE", responseType);
    }

    @Override
    public <T> Observable<T> trace(GenericType<T> responseType) {
        return this.method("TRACE", responseType);
    }

    @Override
    public Observable<Response> method(String name) {
        return this.method(name, Response.class);
    }

    @Override
    public Observable<Response> method(String name, Entity<?> entity) {
        return this.method(name, entity, Response.class);
    }

    @Override
    public <T> Observable<T> method(String name, Entity<?> entity, Class<T> responseType) {
        return this.create(() -> this.syncInvoker.method(name, entity, responseType));
    }

    @Override
    public <T> Observable<T> method(String name, Entity<?> entity, GenericType<T> responseType) {
        return this.create(() -> this.syncInvoker.method(name, entity, responseType));
    }

    @Override
    public <T> Observable<T> method(String name, Class<T> responseType) {
        return this.create(() -> this.syncInvoker.method(name, responseType));
    }

    @Override
    public <T> Observable<T> method(String name, GenericType<T> responseType) {
        return this.create(() -> this.syncInvoker.method(name, responseType));
    }

    private <T> Observable<T> create(final Supplier<T> supplier) {
        Observable observable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<T>(){

            public void subscribe(ObservableEmitter<T> emitter) throws Exception {
                block4: {
                    try {
                        Object response = supplier.get();
                        if (!emitter.isDisposed()) {
                            emitter.onNext(response);
                        }
                        if (!emitter.isDisposed()) {
                            emitter.onComplete();
                        }
                    }
                    catch (Throwable e) {
                        if (emitter.isDisposed()) break block4;
                        emitter.onError(e);
                    }
                }
            }
        });
        if (this.sc == null) {
            return observable.subscribeOn(Schedulers.io());
        }
        return observable.subscribeOn(this.sc).observeOn(this.sc);
    }
}

