/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.reactivestreams.server;

import jakarta.ws.rs.container.AsyncResponse;
import java.util.concurrent.CancellationException;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.jaxrs.impl.AsyncResponseImpl;
import org.apache.cxf.jaxrs.reactivestreams.server.JsonStreamingAsyncSubscriber;
import org.apache.cxf.message.Message;
import org.reactivestreams.Publisher;

public abstract class AbstractReactiveInvoker
extends JAXRSInvoker {
    private boolean useStreamingSubscriberIfPossible = true;

    protected Object handleThrowable(AsyncResponseImpl asyncResponse, Throwable t) {
        if (t instanceof CancellationException) {
            asyncResponse.cancel();
        } else {
            asyncResponse.resume(t);
        }
        return null;
    }

    protected boolean isJsonResponse(Message inMessage) {
        return "application/json".equals(inMessage.getExchange().get((Object)"Content-Type"));
    }

    public boolean isUseStreamingSubscriberIfPossible() {
        return this.useStreamingSubscriberIfPossible;
    }

    protected boolean isStreamingSubscriberUsed(Publisher<?> publisher, AsyncResponse asyncResponse, Message inMessage) {
        if (this.isUseStreamingSubscriberIfPossible() && this.isJsonResponse(inMessage)) {
            publisher.subscribe(new JsonStreamingAsyncSubscriber(asyncResponse));
            return true;
        }
        return false;
    }

    public void setUseStreamingSubscriberIfPossible(boolean useStreamingSubscriberIfPossible) {
        this.useStreamingSubscriberIfPossible = useStreamingSubscriberIfPossible;
    }
}

