/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.reactivestreams.server;

import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.TimeoutHandler;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.StreamingResponse;
import org.apache.cxf.jaxrs.reactivestreams.server.AbstractSubscriber;
import org.apache.cxf.jaxrs.reactivestreams.server.ResponseStatusOnlyException;
import org.reactivestreams.Subscription;

public class StreamingAsyncSubscriber<T>
extends AbstractSubscriber<T> {
    private BlockingQueue<T> queue = new LinkedBlockingQueue<T>();
    private String openTag;
    private String closeTag;
    private String separator;
    private long pollTimeout;
    private long asyncTimeout;
    private volatile boolean completed;
    private volatile Throwable throwable;
    private AtomicBoolean tagsWriteDone = new AtomicBoolean();
    private AtomicBoolean firstWriteDone = new AtomicBoolean();

    public StreamingAsyncSubscriber(AsyncResponse ar, String openTag, String closeTag, String sep) {
        this(ar, openTag, closeTag, sep, 1000L);
    }

    public StreamingAsyncSubscriber(AsyncResponse ar, String openTag, String closeTag, String sep, long pollTimeout) {
        this(ar, openTag, closeTag, sep, pollTimeout, 0L);
    }

    public StreamingAsyncSubscriber(AsyncResponse ar, String openTag, String closeTag, String sep, long pollTimeout, long asyncTimeout) {
        super(ar);
        this.openTag = openTag;
        this.closeTag = closeTag;
        this.separator = sep;
        this.pollTimeout = pollTimeout;
        this.asyncTimeout = 0L;
        if (asyncTimeout > 0L) {
            ar.setTimeout(asyncTimeout, TimeUnit.MILLISECONDS);
            ar.setTimeoutHandler((TimeoutHandler)new TimeoutHandlerImpl());
        }
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        if (this.asyncTimeout == 0L) {
            this.resumeAsyncResponse();
        }
        super.onSubscribe(subscription);
    }

    private void resumeAsyncResponse() {
        super.resume(new StreamingResponseImpl());
    }

    @Override
    public void onComplete() {
        this.completed = true;
    }

    @Override
    public void onError(Throwable t) {
        this.throwable = t;
        this.completed = true;
        super.onError(t);
    }

    @Override
    public void onNext(T bean) {
        if (this.asyncTimeout > 0L && this.getAsyncResponse().isSuspended()) {
            this.resumeAsyncResponse();
        }
        this.queue.add(bean);
        super.requestNext();
    }

    public class TimeoutHandlerImpl
    implements TimeoutHandler {
        public void handleTimeout(AsyncResponse asyncResponse) {
            if (StreamingAsyncSubscriber.this.queue.isEmpty()) {
                asyncResponse.setTimeout(StreamingAsyncSubscriber.this.asyncTimeout, TimeUnit.MILLISECONDS);
            } else {
                StreamingAsyncSubscriber.this.resumeAsyncResponse();
            }
        }
    }

    private final class StreamingResponseImpl
    implements StreamingResponse<T> {
        private StreamingResponseImpl() {
        }

        public void writeTo(StreamingResponse.Writer<T> writer) throws IOException {
            while (!StreamingAsyncSubscriber.this.completed || !StreamingAsyncSubscriber.this.queue.isEmpty()) {
                if (StreamingAsyncSubscriber.this.tagsWriteDone.compareAndSet(false, true) && StreamingAsyncSubscriber.this.openTag != null) {
                    writer.getEntityStream().write(StringUtils.toBytesUTF8((String)StreamingAsyncSubscriber.this.openTag));
                }
                try {
                    Object bean = StreamingAsyncSubscriber.this.queue.poll(StreamingAsyncSubscriber.this.pollTimeout, TimeUnit.MILLISECONDS);
                    if (bean == null) continue;
                    if (StreamingAsyncSubscriber.this.firstWriteDone.getAndSet(true)) {
                        writer.getEntityStream().write(StringUtils.toBytesUTF8((String)StreamingAsyncSubscriber.this.separator));
                    }
                    writer.write(bean);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (StreamingAsyncSubscriber.this.closeTag != null && StreamingAsyncSubscriber.this.tagsWriteDone.get()) {
                writer.getEntityStream().write(StringUtils.toBytesUTF8((String)StreamingAsyncSubscriber.this.closeTag));
            }
            if (StreamingAsyncSubscriber.this.throwable != null) {
                if (StreamingAsyncSubscriber.this.firstWriteDone.get()) {
                    throw new ResponseStatusOnlyException(StreamingAsyncSubscriber.this.throwable);
                }
                if (StreamingAsyncSubscriber.this.throwable instanceof RuntimeException) {
                    throw (RuntimeException)StreamingAsyncSubscriber.this.throwable;
                }
                if (StreamingAsyncSubscriber.this.throwable instanceof IOException) {
                    throw (IOException)StreamingAsyncSubscriber.this.throwable;
                }
                throw new IOException(StreamingAsyncSubscriber.this.throwable);
            }
            if (!StreamingAsyncSubscriber.this.tagsWriteDone.get()) {
                if (StreamingAsyncSubscriber.this.openTag != null) {
                    writer.getEntityStream().write(StringUtils.toBytesUTF8((String)StreamingAsyncSubscriber.this.openTag));
                }
                if (StreamingAsyncSubscriber.this.closeTag != null) {
                    writer.getEntityStream().write(StringUtils.toBytesUTF8((String)StreamingAsyncSubscriber.this.closeTag));
                }
            }
        }
    }
}

