/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.reactivestreams.server;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.reactivestreams.server.ResponseStatusOnlyException;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

@Provider
public class ResponseStatusOnlyExceptionMapper
implements ExceptionMapper<ResponseStatusOnlyException> {
    public Response toResponse(ResponseStatusOnlyException exception) {
        Message message = JAXRSUtils.getCurrentMessage();
        Throwable cause = exception.getCause();
        Response response = ExceptionUtils.convertFaultToResponse((Throwable)cause, (Message)message);
        if (response != null) {
            return Response.fromResponse((Response)response).entity(null).build();
        }
        return Response.serverError().build();
    }
}

