/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jibx;

import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.jibx.JibxNullBindingFactory;
import org.apache.cxf.jibx.JibxSimpleTypes;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.StAXReaderWrapper;
import org.jibx.runtime.impl.UnmarshallingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JibxDataReader
implements DataReader<XMLStreamReader> {
    public Object read(XMLStreamReader input) {
        throw new UnsupportedOperationException();
    }

    public Object read(MessagePartInfo part, XMLStreamReader input) {
        Class type = part.getTypeClass();
        try {
            UnmarshallingContext ctx = JibxDataReader.getUnmarshallingContext(input, type);
            if (JibxSimpleTypes.isSimpleType(type)) {
                QName stype = part.getTypeQName();
                QName ctype = part.getConcreteName();
                if (ctx.isAt(ctype.getNamespaceURI(), ctype.getLocalPart())) {
                    String text = ctx.parseElementText(ctype.getNamespaceURI(), ctype.getLocalPart());
                    return JibxSimpleTypes.toObject(text, stype);
                }
                throw new RuntimeException("Missing required element [" + ctype + "]");
            }
            return ctx.unmarshalElement(part.getTypeClass());
        }
        catch (JiBXException e) {
            throw new RuntimeException(e);
        }
    }

    public Object read(QName elementQName, XMLStreamReader input, Class<?> type) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public void setAttachments(Collection<Attachment> attachments) {
    }

    public void setProperty(String prop, Object value) {
    }

    public void setSchema(Schema s) {
    }

    private static UnmarshallingContext getUnmarshallingContext(XMLStreamReader reader, Class<?> jtype) throws JiBXException {
        JibxNullBindingFactory factory = JibxSimpleTypes.isSimpleType(jtype) ? JibxNullBindingFactory.getFactory() : BindingDirectory.getFactory(jtype);
        UnmarshallingContext ctx = (UnmarshallingContext)factory.createUnmarshallingContext();
        StAXReaderWrapper wrapper = new StAXReaderWrapper(reader, "Data-element", true);
        ctx.setDocument((IXMLReader)wrapper);
        ctx.toTag();
        return ctx;
    }
}

