/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.jbi.interceptor;

import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.jbi.JBIConstants;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;

public class JBIWrapperOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(JBIWrapperOutInterceptor.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();

    public JBIWrapperOutInterceptor() {
        super("marshal");
    }

    public void handleMessage(Message message) throws Fault {
        BindingOperationInfo bop = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        XMLStreamWriter xmlWriter = this.getXMLStreamWriter(message);
        Service service = (Service)message.getExchange().get(Service.class);
        DataWriter dataWriter = this.getDataWriter(message, service, XMLStreamWriter.class);
        try {
            xmlWriter.setPrefix("jbi", "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper");
            xmlWriter.writeStartElement("http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper", JBIConstants.JBI_WRAPPER_MESSAGE.getLocalPart());
            xmlWriter.writeNamespace("jbi", "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper");
            this.setTypeAttr(xmlWriter, message);
            List parts = null;
            parts = !this.isRequestor(message) ? bop.getOutput().getMessageParts() : bop.getInput().getMessageParts();
            List objs = (List)message.getContent(List.class);
            if (objs.size() < parts.size()) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("NOT_EQUAL_ARG_NUM", BUNDLE, new Object[0]));
            }
            for (int idx = 0; idx < parts.size(); ++idx) {
                MessagePartInfo part = (MessagePartInfo)parts.get(idx);
                Object obj = objs.get(part.getIndex());
                if (!part.isElement()) {
                    if (part.getTypeClass() == String.class) {
                        xmlWriter.writeStartElement("http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper", JBIConstants.JBI_WRAPPER_PART.getLocalPart());
                        this.writeWrapper(message, bop, xmlWriter);
                        xmlWriter.writeCharacters(obj.toString());
                        this.writeWrapperEnding(bop, xmlWriter);
                        xmlWriter.writeEndElement();
                        continue;
                    }
                    part = new MessagePartInfo(part.getName(), part.getMessageInfo());
                    part.setElement(false);
                    part.setConcreteName(JBIConstants.JBI_WRAPPER_PART);
                    dataWriter.write(obj, part, (Object)xmlWriter);
                    continue;
                }
                xmlWriter.writeStartElement("http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper", JBIConstants.JBI_WRAPPER_PART.getLocalPart());
                this.writeWrapper(message, bop, xmlWriter);
                dataWriter.write(obj, part, (Object)xmlWriter);
                this.writeWrapperEnding(bop, xmlWriter);
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("STAX_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)e);
        }
    }

    private void writeWrapperEnding(BindingOperationInfo bop, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (bop.isUnwrapped()) {
            xmlWriter.writeEndElement();
        }
    }

    private void writeWrapper(Message message, BindingOperationInfo bop, XMLStreamWriter xmlWriter) {
        if (bop.isUnwrapped()) {
            MessageInfo messageInfo = this.isRequestor(message) ? bop.getWrappedOperation().getOperationInfo().getInput() : bop.getWrappedOperation().getOperationInfo().getOutput();
            MessagePartInfo outPart = (MessagePartInfo)messageInfo.getMessageParts().get(0);
            QName name = outPart.getConcreteName();
            try {
                String pfx = StaxUtils.getUniquePrefix((XMLStreamWriter)xmlWriter, (String)name.getNamespaceURI());
                xmlWriter.setPrefix(pfx, name.getNamespaceURI());
                xmlWriter.writeStartElement(pfx, name.getLocalPart(), name.getNamespaceURI());
                xmlWriter.writeNamespace(pfx, name.getNamespaceURI());
            }
            catch (XMLStreamException e) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("STAX_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)e);
            }
        }
    }

    private void setTypeAttr(XMLStreamWriter xmlWriter, Message message) throws XMLStreamException {
        BindingOperationInfo wsdlOperation = this.getOperation(message);
        BindingMessageInfo wsdlMessage = this.isRequestor(message) ? wsdlOperation.getInput() : wsdlOperation.getOutput();
        String typeNamespace = wsdlMessage.getMessageInfo().getName().getNamespaceURI();
        if (typeNamespace == null || typeNamespace.length() == 0) {
            throw new IllegalArgumentException("messageType namespace is null or empty");
        }
        xmlWriter.writeAttribute("xmlns:msg", typeNamespace);
        String typeLocalName = wsdlMessage.getMessageInfo().getName().getLocalPart();
        if (typeLocalName == null || typeLocalName.length() == 0) {
            throw new IllegalArgumentException("messageType local name is null or empty");
        }
        xmlWriter.writeAttribute("type", "msg:" + typeLocalName);
    }

    protected BindingOperationInfo getOperation(Message message) {
        BindingOperationInfo operation = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        if (operation == null) {
            throw new Fault((Throwable)new Exception("Operation not bound on this message"));
        }
        return operation;
    }

    protected boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.containsKey((Object)"org.apache.cxf.client"));
    }
}

