/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentracing;

import io.opentracing.Tracer;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.opentracing.AbstractOpenTracingClientInterceptor;
import org.apache.cxf.tracing.opentracing.TraceScope;

public class OpenTracingClientStartInterceptor
extends AbstractOpenTracingClientInterceptor {
    public OpenTracingClientStartInterceptor(Tracer tracer) {
        this("pre-stream", tracer);
    }

    public OpenTracingClientStartInterceptor(String phase, Tracer tracer) {
        super(phase, tracer);
    }

    public void handleMessage(Message message) throws Fault {
        Map headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        AbstractTracingProvider.TraceScopeHolder<TraceScope> holder = super.startTraceSpan(headers, OpenTracingClientStartInterceptor.getUri((Message)message), (String)message.get((Object)"org.apache.cxf.request.method"));
        if (holder != null) {
            message.getExchange().put((Object)"org.apache.cxf.tracing.client.opentracing.span", holder);
        }
    }

    @Override
    public void handleFault(Message message) {
        AbstractTracingProvider.TraceScopeHolder holder = (AbstractTracingProvider.TraceScopeHolder)message.getExchange().get((Object)"org.apache.cxf.tracing.client.opentracing.span");
        Exception ex = (Exception)message.getContent(Exception.class);
        super.stopTraceSpan((AbstractTracingProvider.TraceScopeHolder<TraceScope>)holder, ex);
    }
}

