/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentelemetry;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.feature.AbstractPortableFeature;
import org.apache.cxf.feature.DelegatingFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.tracing.opentelemetry.OpenTelemetryStartInterceptor;
import org.apache.cxf.tracing.opentelemetry.OpenTelemetryStopInterceptor;

@NoJSR250Annotations
@Provider(value=Provider.Type.Feature, scope=Provider.Scope.Server)
public class OpenTelemetryFeature
extends DelegatingFeature<Portable> {
    public static final String DEFAULT_INSTRUMENTATION_NAME = "org.apache.cxf";

    public OpenTelemetryFeature() {
        super((AbstractPortableFeature)new Portable());
    }

    public OpenTelemetryFeature(String instrumentationName) {
        super((AbstractPortableFeature)new Portable(instrumentationName));
    }

    public OpenTelemetryFeature(OpenTelemetry openTelemetry) {
        super((AbstractPortableFeature)new Portable(openTelemetry));
    }

    public OpenTelemetryFeature(OpenTelemetry openTelemetry, String instrumentationName) {
        super((AbstractPortableFeature)new Portable(openTelemetry, instrumentationName));
    }

    public OpenTelemetryFeature(OpenTelemetry openTelemetry, Tracer tracer) {
        super((AbstractPortableFeature)new Portable(openTelemetry, tracer));
    }

    public static class Portable
    implements AbstractPortableFeature {
        private final OpenTelemetryStartInterceptor in;
        private final OpenTelemetryStopInterceptor out;

        public Portable() {
            this(GlobalOpenTelemetry.get());
        }

        public Portable(String instrumentationName) {
            this(GlobalOpenTelemetry.get(), instrumentationName);
        }

        public Portable(OpenTelemetry openTelemetry) {
            this(openTelemetry, OpenTelemetryFeature.DEFAULT_INSTRUMENTATION_NAME);
        }

        public Portable(OpenTelemetry openTelemetry, String instrumentationName) {
            this.in = new OpenTelemetryStartInterceptor(openTelemetry, instrumentationName);
            this.out = new OpenTelemetryStopInterceptor(openTelemetry, instrumentationName);
        }

        public Portable(OpenTelemetry openTelemetry, Tracer tracer) {
            this.in = new OpenTelemetryStartInterceptor(openTelemetry, tracer);
            this.out = new OpenTelemetryStopInterceptor(openTelemetry, tracer);
        }

        public void doInitializeProvider(InterceptorProvider provider, Bus bus) {
            provider.getInInterceptors().add(this.in);
            provider.getInFaultInterceptors().add(this.in);
            provider.getOutInterceptors().add(this.out);
            provider.getOutFaultInterceptors().add(this.out);
        }
    }
}

