/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentelemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import java.util.Map;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.opentelemetry.AbstractOpenTelemetryInterceptor;
import org.apache.cxf.tracing.opentelemetry.TraceScope;

@NoJSR250Annotations
public class OpenTelemetryStartInterceptor
extends AbstractOpenTelemetryInterceptor {
    public OpenTelemetryStartInterceptor(OpenTelemetry openTelemetry, String instrumentationName) {
        super("pre-invoke", openTelemetry, instrumentationName);
    }

    public OpenTelemetryStartInterceptor(OpenTelemetry openTelemetry, Tracer tracer) {
        super("pre-invoke", openTelemetry, tracer);
    }

    public void handleMessage(Message message) throws Fault {
        Map headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        AbstractTracingProvider.TraceScopeHolder<TraceScope> holder = super.startTraceSpan(headers, OpenTelemetryStartInterceptor.getUri((Message)message), (String)message.get((Object)"org.apache.cxf.request.method"));
        if (holder != null) {
            message.getExchange().put((Object)"org.apache.cxf.tracing.opentelemetry.span", holder);
        }
    }
}

