/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.opentelemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.opentelemetry.TraceScope;
import org.apache.cxf.tracing.opentelemetry.internal.TextMapInjectAdapter;

public abstract class AbstractOpenTelemetryProvider
extends AbstractTracingProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractOpenTelemetryProvider.class);
    protected static final String TRACE_SPAN = "org.apache.cxf.tracing.opentelemetry.span";
    protected final OpenTelemetry openTelemetry;
    protected final Tracer tracer;

    protected AbstractOpenTelemetryProvider(OpenTelemetry openTelemetry, String instrumentationName) {
        this(openTelemetry, openTelemetry.getTracer(instrumentationName));
    }

    protected AbstractOpenTelemetryProvider(OpenTelemetry openTelemetry, Tracer tracer) {
        this.openTelemetry = openTelemetry;
        this.tracer = tracer;
    }

    protected AbstractTracingProvider.TraceScopeHolder<TraceScope> startTraceSpan(Map<String, List<String>> requestHeaders, URI uri, String method) {
        Context parent = this.openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), requestHeaders, (TextMapGetter)TextMapInjectAdapter.get());
        Scope parentScope = parent.makeCurrent();
        SpanBuilder spanBuilder = this.tracer.spanBuilder(this.buildSpanDescription(uri.getPath(), method)).setSpanKind(SpanKind.SERVER).setAttribute(HttpAttributes.HTTP_REQUEST_METHOD, (Object)method).setAttribute(UrlAttributes.URL_FULL, (Object)uri.toString());
        Span activeSpan = spanBuilder.startSpan();
        Scope scope = activeSpan.makeCurrent();
        Span span = null;
        if (this.isAsyncResponse()) {
            span = activeSpan;
            this.propagateContinuationSpan(span);
            scope.close();
            parentScope.close();
        }
        return new AbstractTracingProvider.TraceScopeHolder((Object)new TraceScope(activeSpan, scope, parentScope), span != null);
    }

    protected void stopTraceSpan(Map<String, List<String>> requestHeaders, Map<String, List<Object>> responseHeaders, int responseStatus, AbstractTracingProvider.TraceScopeHolder<TraceScope> holder) {
        if (holder == null) {
            return;
        }
        TraceScope traceScope = (TraceScope)holder.getScope();
        if (traceScope != null) {
            Span span = traceScope.getSpan();
            Scope scope = traceScope.getScope();
            if (holder.isDetached()) {
                scope = span.makeCurrent();
            }
            span.setAttribute(HttpAttributes.HTTP_RESPONSE_STATUS_CODE, responseStatus);
            span.end();
            scope.close();
            traceScope.getParentScope().close();
        }
    }

    protected boolean isAsyncResponse() {
        return !PhaseInterceptorChain.getCurrentMessage().getExchange().isSynchronous();
    }

    private void propagateContinuationSpan(Span continuation) {
        PhaseInterceptorChain.getCurrentMessage().put(Span.class, (Object)continuation);
    }
}

