/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.micrometer;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.tracing.AbstractTracingProvider;

class ParsedMessage
extends AbstractTracingProvider {
    private Message message;

    ParsedMessage(Message message) {
        this.message = message;
    }

    String safeGet(String key) {
        if (!this.message.containsKey((Object)key)) {
            return null;
        }
        Object value = this.message.get((Object)key);
        return value instanceof String ? value.toString() : null;
    }

    URI getUri() {
        return ParsedMessage.getUri((Message)this.message);
    }

    Message getEffectiveMessage() {
        boolean isRequestor = MessageUtils.isRequestor((Message)this.message);
        boolean isOutbound = MessageUtils.isOutbound((Message)this.message);
        if (isRequestor) {
            return isOutbound ? this.message : this.message.getExchange().getOutMessage();
        }
        return isOutbound ? this.message.getExchange().getInMessage() : this.message;
    }

    Map<String, List<String>> getHeaders() {
        Map headers = CastUtils.cast((Map)((Map)this.message.get((Object)Message.PROTOCOL_HEADERS)));
        if (headers == null) {
            return Collections.emptyMap();
        }
        return headers;
    }

    String getFirstHeader(String key) {
        Map<String, List<String>> headers = this.getHeaders();
        if (headers.containsKey(key)) {
            return headers.get(key).get(0);
        }
        return null;
    }

    void addHeader(String key, String value) {
        HashMap<String, List<String>> headers = CastUtils.cast((Map)((Map)this.message.get((Object)Message.PROTOCOL_HEADERS)));
        if (headers == null) {
            headers = new HashMap<String, List<String>>();
            this.message.put((Object)Message.PROTOCOL_HEADERS, headers);
        }
        headers.put(key, Arrays.asList(value));
    }
}

