/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.micrometer.jaxrs;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import jakarta.ws.rs.client.ClientResponseContext;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tracing.micrometer.jaxrs.AbstractJaxrsObservationConvention;
import org.apache.cxf.tracing.micrometer.jaxrs.ContainerRequestSenderObservationContext;
import org.apache.cxf.tracing.micrometer.jaxrs.ContainerRequestSenderObservationConvention;
import org.apache.cxf.tracing.micrometer.jaxrs.JaxrsObservationDocumentation;

public class DefaultContainerRequestSenderObservationConvention
extends AbstractJaxrsObservationConvention
implements ContainerRequestSenderObservationConvention {
    public static final DefaultContainerRequestSenderObservationConvention INSTANCE = new DefaultContainerRequestSenderObservationConvention();

    public KeyValues getLowCardinalityKeyValues(ContainerRequestSenderObservationContext context) {
        return this.lowCardinalityKeyValues(context.getRequestContext().getMethod(), context.getRequestContext().getUri(), context.getResponse() != null ? Integer.valueOf(((ClientResponseContext)context.getResponse()).getStatus()) : null);
    }

    public KeyValues getHighCardinalityKeyValues(ContainerRequestSenderObservationContext context) {
        String contentLength = context.getRequestContext().getHeaderString("Content-Length");
        int requestLength = StringUtils.isEmpty((String)contentLength) ? -1 : Integer.parseInt(contentLength);
        Integer responseLength = context.getResponse() != null ? Integer.valueOf(((ClientResponseContext)context.getResponse()).getLength()) : null;
        KeyValues keyValues = this.highCardinalityKeyValues(requestLength, responseLength, context.getRequestContext().getHeaderString("User-Agent"));
        return keyValues.and(new KeyValue[]{JaxrsObservationDocumentation.ClientHighCardinalityKeys.URL_FULL.withValue(context.getRequestContext().getUri().toString())});
    }

    public String getName() {
        return "http.client.duration";
    }

    public String getContextualName(ContainerRequestSenderObservationContext context) {
        return context.getRequestContext().getMethod();
    }
}

