/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.brave;

import brave.Tracing;
import brave.http.HttpServerParser;
import brave.http.HttpTracing;
import java.util.UUID;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.feature.AbstractPortableFeature;
import org.apache.cxf.feature.DelegatingFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.tracing.brave.BraveStartInterceptor;
import org.apache.cxf.tracing.brave.BraveStopInterceptor;
import org.apache.cxf.tracing.brave.HttpServerSpanParser;

@NoJSR250Annotations
@Provider(value=Provider.Type.Feature, scope=Provider.Scope.Server)
public class BraveFeature
extends DelegatingFeature<Portable> {
    public BraveFeature() {
        this("cxf-svc-" + UUID.randomUUID().toString());
    }

    public BraveFeature(Tracing tracing) {
        this(Portable.newTracer(tracing));
    }

    public BraveFeature(String name) {
        this(Portable.newTracer(Portable.newTracing(name)));
    }

    public BraveFeature(HttpTracing brave) {
        super((AbstractPortableFeature)new Portable(brave));
    }

    @Provider(value=Provider.Type.Feature, scope=Provider.Scope.Server)
    public static class Portable
    implements AbstractPortableFeature {
        private BraveStartInterceptor in;
        private BraveStopInterceptor out;

        public Portable() {
            this("cxf-svc-" + UUID.randomUUID().toString());
        }

        public Portable(String name) {
            this(Portable.newTracer(Portable.newTracing(name)));
        }

        public Portable(Tracing tracing) {
            this(Portable.newTracer(tracing));
        }

        public Portable(HttpTracing brave) {
            this.in = new BraveStartInterceptor(brave);
            this.out = new BraveStopInterceptor(brave);
        }

        public void doInitializeProvider(InterceptorProvider provider, Bus bus) {
            provider.getInInterceptors().add(this.in);
            provider.getInFaultInterceptors().add(this.in);
            provider.getOutInterceptors().add(this.out);
            provider.getOutFaultInterceptors().add(this.out);
        }

        private static HttpTracing newTracer(Tracing tracing) {
            return HttpTracing.newBuilder((Tracing)tracing).serverParser((HttpServerParser)new HttpServerSpanParser()).build();
        }

        private static Tracing newTracing(String name) {
            return Tracing.newBuilder().localServiceName(name).build();
        }
    }
}

