/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.cdi;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.Configurable;
import jakarta.ws.rs.core.FeatureContext;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.apache.cxf.cdi.event.DisposableCreationalContext;
import org.apache.cxf.jaxrs.impl.ConfigurableImpl;
import org.apache.cxf.jaxrs.impl.ConfigurationImpl;
import org.apache.cxf.jaxrs.provider.ServerConfigurableFactory;

public class CdiServerConfigurableFactory
implements ServerConfigurableFactory {
    private final BeanManager beanManager;

    CdiServerConfigurableFactory(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public Configurable<FeatureContext> create(FeatureContext context) {
        return new CdiServerFeatureContextConfigurable(context, this.beanManager);
    }

    private static class CdiServerFeatureContextConfigurable
    extends ConfigurableImpl<FeatureContext> {
        private final ConfigurableImpl.Instantiator instantiator;

        CdiServerFeatureContextConfigurable(FeatureContext mc, BeanManager beanManager) {
            super((Configurable)mc, RuntimeType.SERVER);
            this.instantiator = new CdiInstantiator(beanManager);
        }

        protected ConfigurableImpl.Instantiator getInstantiator() {
            return this.instantiator;
        }
    }

    private static class CdiInstantiator
    implements ConfigurableImpl.Instantiator {
        private final BeanManager beanManager;

        CdiInstantiator(BeanManager beanManager) {
            this.beanManager = beanManager;
        }

        public <T> Object create(Class<T> cls) {
            Set candidates = this.beanManager.getBeans(cls, new Annotation[0]);
            Bean bean = this.beanManager.resolve(candidates);
            if (bean != null) {
                CreationalContext context = this.beanManager.createCreationalContext((Contextual)bean);
                if (!this.beanManager.isNormalScope(bean.getScope())) {
                    this.beanManager.fireEvent((Object)new DisposableCreationalContext(context), new Annotation[0]);
                }
                return this.beanManager.getReference(bean, cls, context);
            }
            return ConfigurationImpl.createProvider(cls);
        }
    }
}

