/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.soap;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.soap.MAPCodec;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.EncoderDecoder;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RM10Constants;
import org.apache.cxf.ws.rm.RM11Constants;
import org.apache.cxf.ws.rm.RMConfiguration;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.v200702.AckRequestedType;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;
import org.apache.cxf.wsdl.interceptors.BareInInterceptor;
import org.w3c.dom.Element;

public class RMSoapInInterceptor
extends AbstractSoapInterceptor {
    protected static JAXBContext jaxbContext;
    private static final Set<QName> HEADERS;
    private static final Logger LOG;

    public RMSoapInInterceptor() {
        super("pre-protocol");
        this.addAfter(MAPCodec.class.getName());
    }

    public Set<QName> getUnderstoodHeaders() {
        return HEADERS;
    }

    public void handleMessage(SoapMessage message) throws Fault {
        this.decode(message);
        this.updateServiceModelInfo(message);
    }

    void decode(SoapMessage message) {
        RMProperties rmps = this.unmarshalRMProperties(message);
        RMContextUtils.storeRMProperties((Message)message, rmps, false);
    }

    public RMProperties unmarshalRMProperties(SoapMessage message) {
        List headers;
        RMProperties rmps = (RMProperties)message.get((Object)RMContextUtils.getRMPropertiesKey(false));
        if (rmps == null) {
            rmps = new RMProperties();
        }
        if ((headers = message.getHeaders()) != null) {
            this.decodeHeaders(message, headers, rmps);
        }
        return rmps;
    }

    public void decodeHeaders(SoapMessage message, List<Header> headers, RMProperties rmps) {
        try {
            ArrayList<SequenceAcknowledgement> acks = new ArrayList<SequenceAcknowledgement>();
            ArrayList<AckRequestedType> requested = new ArrayList<AckRequestedType>();
            String rmUri = null;
            EncoderDecoder codec = null;
            Iterator<Header> iter = headers.iterator();
            while (iter.hasNext()) {
                Element elem;
                Object node = iter.next().getObject();
                if (!(node instanceof Element) || 1 != (elem = (Element)node).getNodeType()) continue;
                String ns = elem.getNamespaceURI();
                if (rmUri == null && ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(ns) || "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(ns))) {
                    LOG.log(Level.FINE, "set RM namespace {0}", ns);
                    rmUri = ns;
                    rmps.exposeAs(rmUri);
                }
                if (rmUri == null || !rmUri.equals(ns)) continue;
                if (codec == null) {
                    String wsauri;
                    AddressingProperties maps = ContextUtils.retrieveMAPs((Message)message, (boolean)false, (boolean)false, (boolean)false);
                    if (maps == null) {
                        RMConfiguration config = this.getManager(message).getEffectiveConfiguration((Message)message);
                        wsauri = config.getAddressingNamespace();
                    } else {
                        wsauri = maps.getNamespaceURI();
                    }
                    ProtocolVariation protocol = ProtocolVariation.findVariant(rmUri, wsauri);
                    if (protocol == null) {
                        LOG.log(Level.WARNING, "NAMESPACE_ERROR_MSG", wsauri);
                        break;
                    }
                    codec = protocol.getCodec();
                }
                String localName = elem.getLocalName();
                LOG.log(Level.FINE, "decoding RM header {0}", localName);
                if ("Sequence".equals(localName)) {
                    rmps.setSequence(codec.decodeSequenceType(elem));
                    rmps.setCloseSequence(codec.decodeSequenceTypeCloseSequence(elem));
                    continue;
                }
                if ("SequenceAcknowledgement".equals(localName)) {
                    acks.add(codec.decodeSequenceAcknowledgement(elem));
                    continue;
                }
                if (!"AckRequested".equals(localName)) continue;
                requested.add(codec.decodeAckRequestedType(elem));
            }
            if (!acks.isEmpty()) {
                rmps.setAcks(acks);
            }
            if (!requested.isEmpty()) {
                rmps.setAcksRequested(requested);
            }
        }
        catch (JAXBException ex) {
            LOG.log(Level.WARNING, "SOAP_HEADER_DECODE_FAILURE_MSG", ex);
        }
    }

    private void updateServiceModelInfo(SoapMessage message) throws Fault {
        RMEndpoint rme;
        RMConstants consts;
        AddressingProperties maps = ContextUtils.retrieveMAPs((Message)message, (boolean)false, (boolean)false, (boolean)false);
        AttributedURIType actionURI = null == maps ? null : maps.getAction();
        String action = null == actionURI ? null : actionURI.getValue().trim();
        LOG.fine("action: " + action);
        if (RM10Constants.ACTIONS.contains(action)) {
            consts = RM10Constants.INSTANCE;
        } else if (RM11Constants.ACTIONS.contains(action)) {
            consts = RM11Constants.INSTANCE;
        } else {
            return;
        }
        RMProperties rmps = RMContextUtils.retrieveRMProperties((Message)message, false);
        rmps.exposeAs(consts.getWSRMNamespace());
        ProtocolVariation protocol = ProtocolVariation.findVariant(consts.getWSRMNamespace(), maps.getNamespaceURI());
        LOG.info("Updating service model info in exchange");
        RMManager manager = this.getManager(message);
        assert (manager != null);
        try {
            rme = manager.getReliableEndpoint((Message)message);
        }
        catch (RMException e) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("CANNOT_PROCESS", LOG, new Object[0]), (Throwable)((Object)e), message.getVersion().getSender());
        }
        Exchange exchange = message.getExchange();
        Endpoint ep = rme.getEndpoint(protocol);
        exchange.put(Endpoint.class, (Object)ep);
        exchange.put(Service.class, (Object)ep.getService());
        exchange.put(Binding.class, (Object)ep.getBinding());
        BindingInfo bi = ep.getEndpointInfo().getBinding();
        BindingOperationInfo boi = null;
        boolean isOneway = true;
        if (consts.getCreateSequenceAction().equals(action)) {
            if (RMContextUtils.isServerSide((Message)message)) {
                boi = bi.getOperation(consts.getCreateSequenceOperationName());
                isOneway = false;
            } else {
                boi = bi.getOperation(consts.getCreateSequenceOnewayOperationName());
            }
        } else if (consts.getCreateSequenceResponseAction().equals(action)) {
            if (RMContextUtils.isServerSide((Message)message)) {
                boi = bi.getOperation(consts.getCreateSequenceResponseOnewayOperationName());
            } else {
                boi = bi.getOperation(consts.getCreateSequenceOperationName());
                isOneway = false;
            }
        } else if (consts.getSequenceAckAction().equals(action)) {
            boi = bi.getOperation(consts.getSequenceAckOperationName());
        } else if (consts.getAckRequestedAction().equals(action)) {
            boi = bi.getOperation(consts.getAckRequestedOperationName());
        } else if (consts.getTerminateSequenceAction().equals(action)) {
            boi = bi.getOperation(consts.getTerminateSequenceOperationName());
        } else if (RM11Constants.INSTANCE.getTerminateSequenceResponseAction().equals(action)) {
            boi = bi.getOperation(RM11Constants.INSTANCE.getTerminateSequenceOperationName());
            isOneway = false;
        } else if (consts.getCloseSequenceAction().equals(action)) {
            boi = bi.getOperation(consts.getCloseSequenceOperationName());
        } else if (RM11Constants.INSTANCE.getCloseSequenceResponseAction().equals(action)) {
            boi = bi.getOperation(RM11Constants.INSTANCE.getCloseSequenceOperationName());
            isOneway = false;
        }
        if (boi == null) {
            LOG.fine("No BindingInfo for action " + action);
        } else {
            exchange.put(BindingOperationInfo.class, (Object)boi);
            exchange.setOneWay(isOneway);
        }
        if (!(consts.getCreateSequenceResponseAction().equals(action) || consts.getSequenceAckAction().equals(action) || RM11Constants.INSTANCE.getTerminateSequenceResponseAction().equals(action) || RM11Constants.INSTANCE.getCloseSequenceResponseAction().equals(action))) {
            LOG.fine("Changing requestor role from " + message.get((Object)"org.apache.cxf.client") + " to false");
            Object originalRequestorRole = message.get((Object)"org.apache.cxf.client");
            if (null != originalRequestorRole) {
                message.put("org.apache.cxf.client.original", originalRequestorRole);
            }
            message.put("org.apache.cxf.client", (Object)Boolean.FALSE);
        }
        InterceptorChain chain = message.getInterceptorChain();
        ListIterator it = chain.getIterator();
        boolean bareIn = false;
        boolean wrappedIn = false;
        while (it.hasNext() && !wrappedIn && !bareIn) {
            PhaseInterceptor pi = (PhaseInterceptor)it.next();
            if (!BareInInterceptor.class.getName().equals(pi.getId())) continue;
            bareIn = true;
        }
        if (!bareIn) {
            chain.add((Interceptor)new BareInInterceptor());
            LOG.fine("Added BareInInterceptor to chain.");
        }
    }

    private RMManager getManager(SoapMessage message) {
        InterceptorChain chain = message.getInterceptorChain();
        ListIterator it = chain.getIterator();
        while (it.hasNext()) {
            Interceptor i = (Interceptor)it.next();
            if (!(i instanceof AbstractRMInterceptor)) continue;
            return ((AbstractRMInterceptor)i).getManager();
        }
        return null;
    }

    static {
        HashSet<QName> set = new HashSet<QName>();
        set.addAll(RM10Constants.HEADERS);
        set.addAll(RM11Constants.HEADERS);
        HEADERS = set;
        LOG = LogUtils.getL7dLogger(RMSoapInInterceptor.class);
    }
}

