/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.collections;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.collections.JournalHashMap;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.persistence.Persister;

public abstract class AbstractHashMapPersister<K, V>
implements Persister<JournalHashMap.MapRecord<K, V>> {
    private final byte VERSION = 0;

    public byte getID() {
        return 0;
    }

    public final int getEncodeSize(JournalHashMap.MapRecord<K, V> record) {
        return 17 + this.getKeySize(record.key) + this.getValueSize(record.value);
    }

    protected abstract int getKeySize(K var1);

    protected abstract void encodeKey(ActiveMQBuffer var1, K var2);

    protected abstract K decodeKey(ActiveMQBuffer var1);

    protected abstract int getValueSize(V var1);

    protected abstract void encodeValue(ActiveMQBuffer var1, V var2);

    protected abstract V decodeValue(ActiveMQBuffer var1, K var2);

    public final void encode(ActiveMQBuffer buffer, JournalHashMap.MapRecord<K, V> record) {
        buffer.writeLong(record.id);
        buffer.writeByte((byte)0);
        buffer.writeLong(record.collectionID);
        this.encodeKey(buffer, record.key);
        this.encodeValue(buffer, record.value);
    }

    public final JournalHashMap.MapRecord<K, V> decode(ActiveMQBuffer buffer, JournalHashMap.MapRecord<K, V> record, CoreMessageObjectPools pool) {
        long id = buffer.readLong();
        byte version = buffer.readByte();
        assert (version == 0);
        long collectionID = buffer.readLong();
        K key = this.decodeKey(buffer);
        V value = this.decodeValue(buffer, key);
        JournalHashMap.MapRecord<K, V> mapRecord = new JournalHashMap.MapRecord<K, V>(collectionID, id, key, value);
        return mapRecord;
    }
}

