/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature;

import java.security.Key;
import java.security.Provider;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.httpsignature.SignatureValidator;
import org.apache.cxf.rs.security.httpsignature.exception.DifferentAlgorithmsException;
import org.apache.cxf.rs.security.httpsignature.exception.InvalidDataToVerifySignatureException;
import org.apache.cxf.rs.security.httpsignature.exception.InvalidSignatureException;
import org.apache.cxf.rs.security.httpsignature.exception.InvalidSignatureHeaderException;
import org.apache.cxf.rs.security.httpsignature.provider.AlgorithmProvider;
import org.apache.cxf.rs.security.httpsignature.provider.KeyProvider;
import org.apache.cxf.rs.security.httpsignature.provider.SecurityProvider;
import org.apache.cxf.rs.security.httpsignature.utils.SignatureHeaderUtils;
import org.tomitribe.auth.signatures.Signature;
import org.tomitribe.auth.signatures.Verifier;

public class TomitribeSignatureValidator
implements SignatureValidator {
    private static final Logger LOG = LogUtils.getL7dLogger(TomitribeSignatureValidator.class);

    @Override
    public void validate(Map<String, List<String>> messageHeaders, AlgorithmProvider algorithmProvider, KeyProvider keyProvider, SecurityProvider securityProvider, String method, String uri, List<String> requiredHeaders) {
        String signatureAlgorithm;
        Signature signature = TomitribeSignatureValidator.extractSignatureFromHeader(messageHeaders.get("Signature").get(0));
        String providedAlgorithm = algorithmProvider.getAlgorithmName(signature.getKeyId());
        if (!providedAlgorithm.equals(signatureAlgorithm = signature.getAlgorithm().toString())) {
            throw new DifferentAlgorithmsException("signature algorithm from header and provided are different");
        }
        Key key = keyProvider.getKey(signature.getKeyId());
        Provider provider = securityProvider != null ? securityProvider.getProvider(signature.getKeyId()) : null;
        this.runVerifier(messageHeaders, key, signature, provider, method, uri, requiredHeaders);
    }

    private static Signature extractSignatureFromHeader(String signatureString) {
        try {
            return Signature.fromString((String)signatureString);
        }
        catch (Exception e) {
            throw new InvalidSignatureHeaderException("failed to parse signature from header", e);
        }
    }

    private void runVerifier(Map<String, List<String>> messageHeaders, Key key, Signature signature, Provider provider, String method, String uri, List<String> requiredHeaders) {
        boolean success;
        LOG.fine("Starting signature validation");
        try {
            Verifier verifier = new Verifier(key, signature, provider);
            success = verifier.verify(method, uri, SignatureHeaderUtils.mapHeaders(messageHeaders));
            if (!signature.getHeaders().containsAll(requiredHeaders)) {
                LOG.warning("Not all of the required headers are signed");
                throw new InvalidDataToVerifySignatureException();
            }
        }
        catch (Exception e) {
            throw new InvalidDataToVerifySignatureException("Error validating the signature", e);
        }
        if (!success) {
            throw new InvalidSignatureException("signature is not valid");
        }
        LOG.fine("Finished signature validation");
    }
}

