/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ResolvedModule;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.NativeDetector;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.VfsResource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.VfsPatternUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class PathMatchingResourcePatternResolver
implements ResourcePatternResolver {
    private static final Log logger = LogFactory.getLog(PathMatchingResourcePatternResolver.class);
    private static final Set<String> systemModuleNames = NativeDetector.inNativeImage() ? Collections.emptySet() : ModuleFinder.ofSystem().findAll().stream().map(moduleReference -> moduleReference.descriptor().name()).collect(Collectors.toSet());
    private static final Predicate<ResolvedModule> isNotSystemModule = resolvedModule -> !systemModuleNames.contains(resolvedModule.name());
    @Nullable
    private static Method equinoxResolveMethod;
    private final ResourceLoader resourceLoader;
    private PathMatcher pathMatcher = new AntPathMatcher();

    public PathMatchingResourcePatternResolver() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public PathMatchingResourcePatternResolver(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, "ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
    }

    public PathMatchingResourcePatternResolver(@Nullable ClassLoader classLoader) {
        this.resourceLoader = new DefaultResourceLoader(classLoader);
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    @Nullable
    public ClassLoader getClassLoader() {
        return this.getResourceLoader().getClassLoader();
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, "PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    @Override
    public Resource getResource(String location) {
        return this.getResourceLoader().getResource(location);
    }

    @Override
    public Resource[] getResources(String locationPattern) throws IOException {
        int prefixEnd;
        Assert.notNull((Object)locationPattern, "Location pattern must not be null");
        if (locationPattern.startsWith("classpath*:")) {
            String locationPatternWithoutPrefix = locationPattern.substring("classpath*:".length());
            Set<Resource> resources = this.findAllModulePathResources(locationPatternWithoutPrefix);
            if (this.getPathMatcher().isPattern(locationPatternWithoutPrefix)) {
                Collections.addAll(resources, this.findPathMatchingResources(locationPattern));
            } else {
                Collections.addAll(resources, this.findAllClassPathResources(locationPatternWithoutPrefix));
            }
            return resources.toArray(new Resource[0]);
        }
        int n = prefixEnd = locationPattern.startsWith("war:") ? locationPattern.indexOf("*/") + 1 : locationPattern.indexOf(58) + 1;
        if (this.getPathMatcher().isPattern(locationPattern.substring(prefixEnd))) {
            return this.findPathMatchingResources(locationPattern);
        }
        return new Resource[]{this.getResourceLoader().getResource(locationPattern)};
    }

    protected Resource[] findAllClassPathResources(String location) throws IOException {
        String path = PathMatchingResourcePatternResolver.stripLeadingSlash(location);
        Set<Resource> result = this.doFindAllClassPathResources(path);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Resolved classpath location [" + path + "] to resources " + result));
        }
        return result.toArray(new Resource[0]);
    }

    protected Set<Resource> doFindAllClassPathResources(String path) throws IOException {
        Enumeration<URL> resourceUrls;
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(16);
        ClassLoader cl = this.getClassLoader();
        Enumeration<URL> enumeration = resourceUrls = cl != null ? cl.getResources(path) : ClassLoader.getSystemResources(path);
        while (resourceUrls.hasMoreElements()) {
            URL url = resourceUrls.nextElement();
            result.add(this.convertClassLoaderURL(url));
        }
        if (!StringUtils.hasLength(path)) {
            this.addAllClassLoaderJarRoots(cl, result);
        }
        return result;
    }

    protected Resource convertClassLoaderURL(URL url) {
        if ("file".equals(url.getProtocol())) {
            try {
                return new FileSystemResource(ResourceUtils.toURI(url).getSchemeSpecificPart());
            }
            catch (URISyntaxException ex) {
                return new FileSystemResource(url.getFile());
            }
        }
        return new UrlResource(url);
    }

    protected void addAllClassLoaderJarRoots(@Nullable ClassLoader classLoader, Set<Resource> result) {
        block11: {
            block10: {
                if (classLoader instanceof URLClassLoader) {
                    URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
                    try {
                        for (URL url : urlClassLoader.getURLs()) {
                            try {
                                UrlResource jarResource;
                                UrlResource urlResource = jarResource = "jar".equals(url.getProtocol()) ? new UrlResource(url) : new UrlResource("jar:" + url + "!/");
                                if (!jarResource.exists()) continue;
                                result.add(jarResource);
                            }
                            catch (MalformedURLException ex) {
                                if (!logger.isDebugEnabled()) continue;
                                logger.debug((Object)("Cannot search for matching files underneath [" + url + "] because it cannot be converted to a valid 'jar:' URL: " + ex.getMessage()));
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (!logger.isDebugEnabled()) break block10;
                        logger.debug((Object)("Cannot introspect jar files since ClassLoader [" + classLoader + "] does not support 'getURLs()': " + ex));
                    }
                }
            }
            if (classLoader == ClassLoader.getSystemClassLoader()) {
                this.addClassPathManifestEntries(result);
            }
            if (classLoader != null) {
                try {
                    this.addAllClassLoaderJarRoots(classLoader.getParent(), result);
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block11;
                    logger.debug((Object)("Cannot introspect jar files in parent ClassLoader since [" + classLoader + "] does not support 'getParent()': " + ex));
                }
            }
        }
    }

    protected void addClassPathManifestEntries(Set<Resource> result) {
        block6: {
            try {
                String javaClassPathProperty = System.getProperty("java.class.path");
                for (String path : StringUtils.delimitedListToStringArray(javaClassPathProperty, System.getProperty("path.separator"))) {
                    try {
                        UrlResource jarResource;
                        String filePath = new File(path).getAbsolutePath();
                        int prefixIndex = filePath.indexOf(58);
                        if (prefixIndex == 1) {
                            filePath = StringUtils.capitalize(filePath);
                        }
                        if (result.contains(jarResource = new UrlResource("jar:file:" + (filePath = StringUtils.replace(filePath, "#", "%23")) + "!/")) || this.hasDuplicate(filePath, result) || !jarResource.exists()) continue;
                        result.add(jarResource);
                    }
                    catch (MalformedURLException ex) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Cannot search for matching files underneath [" + path + "] because it cannot be converted to a valid 'jar:' URL: " + ex.getMessage()));
                    }
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug((Object)("Failed to evaluate 'java.class.path' manifest entries: " + ex));
            }
        }
    }

    private boolean hasDuplicate(String filePath, Set<Resource> result) {
        if (result.isEmpty()) {
            return false;
        }
        Object duplicatePath = filePath.startsWith("/") ? filePath.substring(1) : "/" + filePath;
        try {
            return result.contains(new UrlResource("jar:file:" + (String)duplicatePath + "!/"));
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    protected Resource[] findPathMatchingResources(String locationPattern) throws IOException {
        String rootDirPath = this.determineRootDir(locationPattern);
        String subPattern = locationPattern.substring(rootDirPath.length());
        Resource[] rootDirResources = this.getResources(rootDirPath);
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(16);
        for (Resource rootDirResource : rootDirResources) {
            rootDirResource = this.resolveRootDirResource(rootDirResource);
            URL rootDirUrl = rootDirResource.getURL();
            if (equinoxResolveMethod != null && rootDirUrl.getProtocol().startsWith("bundle")) {
                URL resolvedUrl = (URL)ReflectionUtils.invokeMethod(equinoxResolveMethod, null, rootDirUrl);
                if (resolvedUrl != null) {
                    rootDirUrl = resolvedUrl;
                }
                rootDirResource = new UrlResource(rootDirUrl);
            }
            if (rootDirUrl.getProtocol().startsWith("vfs")) {
                result.addAll(VfsResourceMatchingDelegate.findMatchingResources(rootDirUrl, subPattern, this.getPathMatcher()));
                continue;
            }
            if (ResourceUtils.isJarURL(rootDirUrl) || this.isJarResource(rootDirResource)) {
                result.addAll(this.doFindPathMatchingJarResources(rootDirResource, rootDirUrl, subPattern));
                continue;
            }
            result.addAll(this.doFindPathMatchingFileResources(rootDirResource, subPattern));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Resolved location pattern [" + locationPattern + "] to resources " + result));
        }
        return result.toArray(new Resource[0]);
    }

    protected String determineRootDir(String location) {
        int prefixEnd = location.indexOf(58) + 1;
        int rootDirEnd = location.length();
        while (rootDirEnd > prefixEnd && this.getPathMatcher().isPattern(location.substring(prefixEnd, rootDirEnd))) {
            rootDirEnd = location.lastIndexOf(47, rootDirEnd - 2) + 1;
        }
        if (rootDirEnd == 0) {
            rootDirEnd = prefixEnd;
        }
        return location.substring(0, rootDirEnd);
    }

    protected Resource resolveRootDirResource(Resource original) throws IOException {
        return original;
    }

    protected boolean isJarResource(Resource resource) throws IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Resource> doFindPathMatchingJarResources(Resource rootDirResource, URL rootDirUrl, String subPattern) throws IOException {
        boolean closeJarFile;
        Object rootEntryPath;
        String jarFileUrl;
        JarFile jarFile;
        URLConnection con = rootDirUrl.openConnection();
        if (con instanceof JarURLConnection) {
            JarURLConnection jarCon = (JarURLConnection)con;
            ResourceUtils.useCachesIfNecessary(jarCon);
            jarFile = jarCon.getJarFile();
            jarFileUrl = jarCon.getJarFileURL().toExternalForm();
            JarEntry jarEntry = jarCon.getJarEntry();
            rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
            closeJarFile = !jarCon.getUseCaches();
        } else {
            String urlFile = rootDirUrl.getFile();
            try {
                int separatorIndex = urlFile.indexOf("*/");
                if (separatorIndex == -1) {
                    separatorIndex = urlFile.indexOf("!/");
                }
                if (separatorIndex != -1) {
                    jarFileUrl = urlFile.substring(0, separatorIndex);
                    rootEntryPath = urlFile.substring(separatorIndex + 2);
                    jarFile = this.getJarFile(jarFileUrl);
                } else {
                    jarFile = new JarFile(urlFile);
                    jarFileUrl = urlFile;
                    rootEntryPath = "";
                }
                closeJarFile = true;
            }
            catch (ZipException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Skipping invalid jar classpath entry [" + urlFile + "]"));
                }
                return Collections.emptySet();
            }
        }
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Looking for matching resources in jar file [" + jarFileUrl + "]"));
            }
            if (StringUtils.hasLength((String)rootEntryPath) && !((String)rootEntryPath).endsWith("/")) {
                rootEntryPath = (String)rootEntryPath + "/";
            }
            LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(8);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                if (!entryPath.startsWith((String)rootEntryPath)) continue;
                String relativePath = entryPath.substring(((String)rootEntryPath).length());
                if (!this.getPathMatcher().match(subPattern, relativePath)) continue;
                result.add(rootDirResource.createRelative(relativePath));
            }
            LinkedHashSet<Resource> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            if (closeJarFile) {
                jarFile.close();
            }
        }
    }

    protected JarFile getJarFile(String jarFileUrl) throws IOException {
        if (jarFileUrl.startsWith("file:")) {
            try {
                return new JarFile(ResourceUtils.toURI(jarFileUrl).getSchemeSpecificPart());
            }
            catch (URISyntaxException ex) {
                return new JarFile(jarFileUrl.substring("file:".length()));
            }
        }
        return new JarFile(jarFileUrl);
    }

    protected Set<Resource> doFindPathMatchingFileResources(Resource rootDirResource, String subPattern) throws IOException {
        LinkedHashSet<Resource> result;
        block20: {
            Object rootDir;
            Path rootPath;
            block19: {
                URI rootDirUri;
                try {
                    rootDirUri = rootDirResource.getURI();
                }
                catch (Exception ex) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)"Failed to resolve directory [%s] as URI: %s".formatted(rootDirResource, ex));
                    }
                    return Collections.emptySet();
                }
                rootPath = null;
                if (rootDirUri.isAbsolute() && !rootDirUri.isOpaque()) {
                    try {
                        try {
                            rootPath = Path.of(rootDirUri);
                        }
                        catch (FileSystemNotFoundException ex) {
                            FileSystems.newFileSystem(rootDirUri, Map.of(), ClassUtils.getDefaultClassLoader());
                            rootPath = Path.of(rootDirUri);
                        }
                    }
                    catch (Exception ex) {
                        if (!logger.isDebugEnabled()) break block19;
                        logger.debug((Object)"Failed to resolve %s in file system: %s".formatted(rootDirUri, ex));
                    }
                }
            }
            if (rootPath == null) {
                rootPath = Path.of(rootDirResource.getFile().getAbsolutePath(), new String[0]);
            }
            if (!((String)(rootDir = StringUtils.cleanPath(rootPath.toString()))).endsWith("/")) {
                rootDir = (String)rootDir + "/";
            }
            Path rootPathForPattern = rootPath;
            String resourcePattern = (String)rootDir + StringUtils.cleanPath(subPattern);
            Predicate<Path> isMatchingFile = path -> !path.equals(rootPathForPattern) && this.getPathMatcher().match(resourcePattern, StringUtils.cleanPath(path.toString()));
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Searching directory [%s] for files matching pattern [%s]".formatted(rootPath.toAbsolutePath(), subPattern));
            }
            result = new LinkedHashSet<Resource>();
            try (Stream<Path> files = Files.walk(rootPath, new FileVisitOption[0]);){
                files.filter(isMatchingFile).sorted().map(FileSystemResource::new).forEach(result::add);
            }
            catch (Exception ex) {
                if (!logger.isWarnEnabled()) break block20;
                logger.warn((Object)"Failed to search in directory [%s] for files matching pattern [%s]: %s".formatted(rootPath.toAbsolutePath(), subPattern, ex));
            }
        }
        return result;
    }

    protected Set<Resource> findAllModulePathResources(String locationPattern) throws IOException {
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(16);
        if (NativeDetector.inNativeImage()) {
            return result;
        }
        String resourcePattern = PathMatchingResourcePatternResolver.stripLeadingSlash(locationPattern);
        Predicate<String> resourcePatternMatches = this.getPathMatcher().isPattern(resourcePattern) ? path -> this.getPathMatcher().match(resourcePattern, (String)path) : resourcePattern::equals;
        try {
            ModuleLayer.boot().configuration().modules().stream().filter(isNotSystemModule).forEach(resolvedModule -> {
                try (ModuleReader moduleReader = resolvedModule.reference().open();
                     Stream<String> names = moduleReader.list();){
                    names.filter(resourcePatternMatches).map(name -> this.findResource(moduleReader, (String)name)).filter(Objects::nonNull).forEach(result::add);
                }
                catch (IOException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Failed to read contents of module [%s]".formatted(resolvedModule), (Throwable)ex);
                    }
                    throw new UncheckedIOException(ex);
                }
            });
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Resolved module-path location pattern [%s] to resources %s".formatted(resourcePattern, result));
        }
        return result;
    }

    @Nullable
    private Resource findResource(ModuleReader moduleReader, String name) {
        try {
            return moduleReader.find(name).map(this::convertModuleSystemURI).orElse(null);
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to find resource [%s] in module path".formatted(name), (Throwable)ex);
            }
            return null;
        }
    }

    private Resource convertModuleSystemURI(URI uri) {
        return "file".equals(uri.getScheme()) ? new FileSystemResource(uri.getPath()) : UrlResource.from(uri);
    }

    private static String stripLeadingSlash(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }

    static {
        try {
            Class<?> fileLocatorClass = ClassUtils.forName("org.eclipse.core.runtime.FileLocator", PathMatchingResourcePatternResolver.class.getClassLoader());
            equinoxResolveMethod = fileLocatorClass.getMethod("resolve", URL.class);
            logger.trace((Object)"Found Equinox FileLocator for OSGi bundle URL resolution");
        }
        catch (Throwable ex) {
            equinoxResolveMethod = null;
        }
    }

    private static class VfsResourceMatchingDelegate {
        private VfsResourceMatchingDelegate() {
        }

        public static Set<Resource> findMatchingResources(URL rootDirUrl, String locationPattern, PathMatcher pathMatcher) throws IOException {
            Object root = VfsPatternUtils.findRoot(rootDirUrl);
            PatternVirtualFileVisitor visitor = new PatternVirtualFileVisitor(VfsPatternUtils.getPath(root), locationPattern, pathMatcher);
            VfsPatternUtils.visit(root, visitor);
            return visitor.getResources();
        }
    }

    private static class PatternVirtualFileVisitor
    implements InvocationHandler {
        private final String subPattern;
        private final PathMatcher pathMatcher;
        private final String rootPath;
        private final Set<Resource> resources = new LinkedHashSet<Resource>();

        public PatternVirtualFileVisitor(String rootPath, String subPattern, PathMatcher pathMatcher) {
            this.subPattern = subPattern;
            this.pathMatcher = pathMatcher;
            this.rootPath = rootPath.isEmpty() || rootPath.endsWith("/") ? rootPath : rootPath + "/";
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (Object.class == method.getDeclaringClass()) {
                if (methodName.equals("equals")) {
                    return proxy == args[0];
                }
                if (methodName.equals("hashCode")) {
                    return System.identityHashCode(proxy);
                }
            } else {
                if ("getAttributes".equals(methodName)) {
                    return this.getAttributes();
                }
                if ("visit".equals(methodName)) {
                    this.visit(args[0]);
                    return null;
                }
                if ("toString".equals(methodName)) {
                    return this.toString();
                }
            }
            throw new IllegalStateException("Unexpected method invocation: " + method);
        }

        public void visit(Object vfsResource) {
            if (this.pathMatcher.match(this.subPattern, VfsPatternUtils.getPath(vfsResource).substring(this.rootPath.length()))) {
                this.resources.add(new VfsResource(vfsResource));
            }
        }

        @Nullable
        public Object getAttributes() {
            return VfsPatternUtils.getVisitorAttributes();
        }

        public Set<Resource> getResources() {
            return this.resources;
        }

        public int size() {
            return this.resources.size();
        }

        public String toString() {
            return "sub-pattern: " + this.subPattern + ", resources: " + this.resources;
        }
    }
}

