/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.transport.http.HttpUrlUtil;
import org.apache.cxf.transport.http.netty.server.NettyHttpDestination;

public class NettyHttpHandler {
    private String urlName;
    private boolean contextMatchExact;
    private NettyHttpDestination nettyHttpDestination;
    private ServletContext servletContext;

    public NettyHttpHandler(NettyHttpDestination nhd, boolean cmExact) {
        this.contextMatchExact = cmExact;
        this.nettyHttpDestination = nhd;
    }

    public void setServletContext(ServletContext sc) {
        this.servletContext = sc;
        if (this.nettyHttpDestination != null) {
            this.nettyHttpDestination.setServletContext(sc);
        }
    }

    public void setName(String name) {
        this.urlName = name;
    }

    public String getName() {
        return this.urlName;
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.contextMatchExact) {
            if (target.equals(this.urlName)) {
                this.nettyHttpDestination.doService(this.servletContext, request, response);
            }
        } else if (target.equals(this.urlName) || HttpUrlUtil.checkContextPath((String)this.getName(), (String)target)) {
            this.nettyHttpDestination.doService(this.servletContext, request, response);
        }
    }

    public String getContextPath() {
        return this.servletContext.getContextPath();
    }
}

