/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client;

import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.jaxrs.impl.ConfigurableImpl;
import org.apache.cxf.jaxrs.impl.ConfigurationImpl;
import org.apache.cxf.microprofile.client.cdi.CDIFacade;
import org.apache.cxf.microprofile.client.config.ConfigFacade;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;

public class MicroProfileClientConfigurableImpl<C extends Configurable<C>>
extends ConfigurableImpl<C>
implements Configurable<C> {
    static final Class<?>[] CONTRACTS = new Class[]{ClientRequestFilter.class, ClientResponseFilter.class, ReaderInterceptor.class, WriterInterceptor.class, MessageBodyWriter.class, MessageBodyReader.class, ResponseExceptionMapper.class};
    private static final String CONFIG_KEY_DISABLE_MAPPER = "microprofile.rest.client.disable.default.mapper";
    private final ConfigurableImpl.Instantiator instantiator = CDIFacade.getInstantiator().orElse(super.getInstantiator());

    public MicroProfileClientConfigurableImpl(C configurable) {
        this(configurable, null);
    }

    public MicroProfileClientConfigurableImpl(C configurable, Configuration config) {
        super(configurable, (Configuration)(config == null ? new ConfigurationImpl(RuntimeType.CLIENT) : new ConfigurationImpl(config)));
    }

    boolean isDefaultExceptionMapperDisabled() {
        Object prop = this.getConfiguration().getProperty(CONFIG_KEY_DISABLE_MAPPER);
        if (prop != null) {
            return PropertyUtils.isTrue((Object)prop);
        }
        return ConfigFacade.getOptionalValue(CONFIG_KEY_DISABLE_MAPPER, Boolean.class).orElse(false);
    }

    protected ConfigurableImpl.Instantiator getInstantiator() {
        return this.instantiator;
    }
}

