/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import javax.transaction.Transaction;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSFactory;
import org.apache.cxf.transport.jms.util.AbstractMessageListenerContainer;
import org.apache.cxf.transport.jms.util.JMSUtil;
import org.apache.cxf.transport.jms.util.ResourceCloser;

public class PollingMessageListenerContainer
extends AbstractMessageListenerContainer {
    private static final Logger LOG = LogUtils.getL7dLogger(PollingMessageListenerContainer.class);
    private ExceptionListener exceptionListener;
    private JMSConfiguration jmsConfig;
    private boolean reply;

    public PollingMessageListenerContainer(JMSConfiguration jmsConfig, boolean isReply, MessageListener listenerHandler) {
        this(jmsConfig, isReply, listenerHandler, null);
    }

    public PollingMessageListenerContainer(JMSConfiguration jmsConfig, boolean isReply, MessageListener listenerHandler, ExceptionListener exceptionListener) {
        this.jmsConfig = jmsConfig;
        this.reply = isReply;
        this.listenerHandler = listenerHandler;
        this.exceptionListener = exceptionListener;
    }

    public PollingMessageListenerContainer(Connection connection, Destination destination, MessageListener listenerHandler, ExceptionListener exceptionListener) {
        this.connection = connection;
        this.destination = destination;
        this.listenerHandler = listenerHandler;
        this.exceptionListener = exceptionListener;
    }

    private MessageConsumer createConsumer(Connection connection, Session session) throws JMSException {
        MessageConsumer consumer;
        if (this.jmsConfig != null && this.jmsConfig.isOneSessionPerConnection()) {
            Destination destination = !this.isReply() ? this.jmsConfig.getTargetDestination(session) : this.jmsConfig.getReplyDestination(session);
            consumer = this.createConsumer(destination, session);
            connection.start();
        } else {
            consumer = this.createConsumer(session);
        }
        return consumer;
    }

    private MessageConsumer createConsumer(Session session) throws JMSException {
        return this.createConsumer(this.destination, session);
    }

    private MessageConsumer createConsumer(Destination destination, Session session) throws JMSException {
        if (this.durableSubscriptionName != null && destination instanceof Topic) {
            return session.createDurableSubscriber((Topic)destination, this.durableSubscriptionName, this.messageSelector, this.pubSubNoLocal);
        }
        return session.createConsumer(destination, this.messageSelector);
    }

    protected void handleException(Throwable e) {
        JMSException wrapped;
        this.running = false;
        if (e instanceof JMSException) {
            wrapped = (JMSException)e;
        } else {
            wrapped = new JMSException("Wrapped exception. " + e.getMessage());
            wrapped.addSuppressed(e);
        }
        if (this.exceptionListener != null) {
            this.exceptionListener.onException(wrapped);
        }
    }

    private boolean isReply() {
        return this.reply;
    }

    private Connection createConnection() {
        try {
            return JMSFactory.createConnection(this.jmsConfig);
        }
        catch (JMSException e) {
            this.handleException(e);
            throw JMSUtil.convertJmsException(e);
        }
    }

    @Override
    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        for (int c = 0; c < this.getConcurrentConsumers(); ++c) {
            Runnable poller = this.transactionManager != null ? new XAPoller() : new Poller();
            this.getExecutor().execute(poller);
        }
    }

    @Override
    public void stop() {
        LOG.fine("Shutting down " + this.getClass().getSimpleName());
        this.running = false;
        super.stop();
    }

    @Override
    public void shutdown() {
        this.stop();
    }

    private class XAPoller
    implements Runnable {
        private XAPoller() {
        }

        @Override
        public void run() {
            while (PollingMessageListenerContainer.this.running) {
                try {
                    ResourceCloser closer = new ResourceCloser();
                    Throwable throwable = null;
                    try {
                        closer.register(PollingMessageListenerContainer.this.createInitialContext());
                        Transaction externalTransaction = PollingMessageListenerContainer.this.transactionManager.getTransaction();
                        if (externalTransaction != null && externalTransaction.getStatus() == 0) {
                            LOG.log(Level.SEVERE, "External transactions are not supported in XAPoller");
                            throw new IllegalStateException("External transactions are not supported in XAPoller");
                        }
                        PollingMessageListenerContainer.this.transactionManager.begin();
                        Connection connection = PollingMessageListenerContainer.this.getConnection() == null ? closer.register(PollingMessageListenerContainer.this.createConnection()) : PollingMessageListenerContainer.this.getConnection();
                        Session session = closer.register(connection.createSession(PollingMessageListenerContainer.this.transacted, PollingMessageListenerContainer.this.acknowledgeMode));
                        MessageConsumer consumer = closer.register(PollingMessageListenerContainer.this.createConsumer(connection, session));
                        Message message = consumer.receive(1000L);
                        try {
                            if (message != null) {
                                PollingMessageListenerContainer.this.listenerHandler.onMessage(message);
                            }
                            PollingMessageListenerContainer.this.transactionManager.commit();
                        }
                        catch (Throwable e) {
                            LOG.log(Level.WARNING, "Exception while processing jms message in cxf. Rolling back", e);
                            this.safeRollBack();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (closer == null) continue;
                        if (throwable != null) {
                            try {
                                closer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        closer.close();
                    }
                }
                catch (Throwable e) {
                    this.safeRollBack();
                    PollingMessageListenerContainer.this.handleException(e);
                }
            }
        }

        private void safeRollBack() {
            try {
                PollingMessageListenerContainer.this.transactionManager.rollback();
            }
            catch (Throwable e) {
                LOG.log(Level.WARNING, "Rollback of XA transaction failed", e);
            }
        }
    }

    private class Poller
    implements Runnable {
        private Poller() {
        }

        @Override
        public void run() {
            Session session = null;
            while (PollingMessageListenerContainer.this.running) {
                try {
                    ResourceCloser closer = new ResourceCloser();
                    Throwable throwable = null;
                    try {
                        closer.register(PollingMessageListenerContainer.this.createInitialContext());
                        Connection connection = PollingMessageListenerContainer.this.jmsConfig != null && PollingMessageListenerContainer.this.jmsConfig.isOneSessionPerConnection() ? closer.register(PollingMessageListenerContainer.this.createConnection()) : PollingMessageListenerContainer.this.connection;
                        session = closer.register(connection.createSession(PollingMessageListenerContainer.this.transacted, PollingMessageListenerContainer.this.acknowledgeMode));
                        MessageConsumer consumer = closer.register(PollingMessageListenerContainer.this.createConsumer(connection, session));
                        while (PollingMessageListenerContainer.this.running) {
                            Message message = consumer.receive(1000L);
                            try {
                                if (message == null) continue;
                                PollingMessageListenerContainer.this.listenerHandler.onMessage(message);
                                if (!session.getTransacted()) continue;
                                session.commit();
                            }
                            catch (Throwable e) {
                                LOG.log(Level.WARNING, "Exception while processing jms message in cxf. Rolling back", e);
                                this.safeRollBack(session);
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (closer == null) continue;
                        if (throwable != null) {
                            try {
                                closer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        closer.close();
                    }
                }
                catch (Throwable e) {
                    PollingMessageListenerContainer.this.handleException(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        protected void safeRollBack(Session session) {
            try {
                if (session != null && session.getTransacted()) {
                    session.rollback();
                }
            }
            catch (Throwable e1) {
                LOG.log(Level.WARNING, "Rollback of Local transaction failed", e1);
            }
        }
    }
}

