/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.transport.http.netty.client.NettyHttpClientHandler;
import org.apache.cxf.transport.http.netty.client.NettyHttpConduit;
import org.apache.cxf.transport.https.SSLUtils;

public class NettyHttpClientPipelineFactory
extends ChannelInitializer<Channel> {
    private static final Logger LOG = LogUtils.getL7dLogger(NettyHttpClientPipelineFactory.class);
    private final TLSClientParameters tlsClientParameters;
    private final int readTimeout;
    private final int maxContentLength;

    public NettyHttpClientPipelineFactory(TLSClientParameters clientParameters) {
        this(clientParameters, 0);
    }

    public NettyHttpClientPipelineFactory(TLSClientParameters clientParameters, int readTimeout) {
        this(clientParameters, readTimeout, NettyHttpConduit.DEFAULT_MAX_RESPONSE_CONTENT_LENGTH);
    }

    public NettyHttpClientPipelineFactory(TLSClientParameters clientParameters, int readTimeout, int maxResponseContentLength) {
        this.tlsClientParameters = clientParameters;
        this.readTimeout = readTimeout;
        this.maxContentLength = maxResponseContentLength;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        SslHandler sslHandler = this.configureClientSSLOnDemand();
        if (sslHandler != null) {
            LOG.log(Level.FINE, "Server SSL handler configured and added as an interceptor against the ChannelPipeline: {}", sslHandler);
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
        pipeline.addLast("decoder", (ChannelHandler)new HttpResponseDecoder());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(this.maxContentLength));
        pipeline.addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
        pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        if (this.readTimeout > 0) {
            pipeline.addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler((long)this.readTimeout, TimeUnit.MILLISECONDS));
        }
        pipeline.addLast("client", (ChannelHandler)new NettyHttpClientHandler());
    }

    private SslHandler configureClientSSLOnDemand() throws Exception {
        if (this.tlsClientParameters != null) {
            SSLEngine sslEngine = SSLUtils.createClientSSLEngine((TLSClientParameters)this.tlsClientParameters);
            return new SslHandler(sslEngine);
        }
        return null;
    }
}

