/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcp.xml.dsig.internal.dom;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.apache.jcp.xml.dsig.internal.dom.BaseStructure;
import org.apache.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.apache.jcp.xml.dsig.internal.dom.XmlWriter;
import org.w3c.dom.Element;

abstract class AbstractDOMSignatureMethod
extends BaseStructure
implements SignatureMethod {
    AbstractDOMSignatureMethod() {
    }

    abstract boolean verify(Key var1, DOMSignedInfo var2, byte[] var3, XMLValidateContext var4) throws InvalidKeyException, SignatureException, XMLSignatureException;

    abstract byte[] sign(Key var1, DOMSignedInfo var2, XMLSignContext var3) throws InvalidKeyException, XMLSignatureException;

    abstract String getJCAAlgorithm();

    abstract Type getAlgorithmType();

    public void marshal(XmlWriter xwriter, String dsPrefix) throws MarshalException {
        xwriter.writeStartElement(dsPrefix, "SignatureMethod", "http://www.w3.org/2000/09/xmldsig#");
        xwriter.writeAttribute("", "", "Algorithm", this.getAlgorithm());
        if (this.getParameterSpec() != null) {
            this.marshalParams(xwriter, dsPrefix);
        }
        xwriter.writeEndElement();
    }

    void marshalParams(XmlWriter xwriter, String paramsPrefix) throws MarshalException {
        throw new MarshalException("no parameters should be specified for the " + this.getAlgorithm() + " SignatureMethod algorithm");
    }

    SignatureMethodParameterSpec unmarshalParams(Element paramsElem) throws MarshalException {
        throw new MarshalException("no parameters should be specified for the " + this.getAlgorithm() + " SignatureMethod algorithm");
    }

    void checkParams(SignatureMethodParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("no parameters should be specified for the " + this.getAlgorithm() + " SignatureMethod algorithm");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SignatureMethod)) {
            return false;
        }
        SignatureMethod osm = (SignatureMethod)o;
        return this.getAlgorithm().equals(osm.getAlgorithm()) && this.paramsEqual(osm.getParameterSpec());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getAlgorithm().hashCode();
        AlgorithmParameterSpec spec = this.getParameterSpec();
        if (spec != null) {
            result = 31 * result + spec.hashCode();
        }
        return result;
    }

    boolean paramsEqual(AlgorithmParameterSpec spec) {
        return this.getParameterSpec() == spec;
    }

    static enum Type {
        DSA,
        RSA,
        ECDSA,
        HMAC;

    }
}

