/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.sse.atmosphere;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.sse.atmosphere.SseAtmosphereInterceptorWriter;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptor;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.interceptor.AllowInterceptor;
import org.atmosphere.interceptor.SSEAtmosphereInterceptor;
import org.atmosphere.util.Utils;

public class SseAtmosphereInterceptor
extends SSEAtmosphereInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(SseAtmosphereInterceptor.class);
    private static final byte[] PADDING;
    private static final String PADDING_TEXT;
    private static final byte[] END;

    private boolean writePadding(AtmosphereResponse response) {
        if (response.request() != null && response.request().getAttribute("paddingWritten") != null) {
            return false;
        }
        response.setContentType("text/event-stream");
        response.setCharacterEncoding("utf-8");
        boolean isUsingStream = (Boolean)response.request().getAttribute("org.atmosphere.useStream");
        if (isUsingStream) {
            try {
                ServletOutputStream stream = response.getResponse().getOutputStream();
                try {
                    stream.write(PADDING);
                    stream.flush();
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "SSE may not work", ex);
                }
            }
            catch (IOException e) {
                LOG.log(Level.FINEST, "", e);
            }
        } else {
            try {
                PrintWriter w = response.getResponse().getWriter();
                w.println(PADDING_TEXT);
                w.flush();
            }
            catch (IOException e) {
                LOG.log(Level.FINEST, "", e);
            }
        }
        response.resource().getRequest().setAttribute("paddingWritten", (Object)"true");
        return true;
    }

    public Action inspect(final AtmosphereResource r) {
        String accept;
        if (Utils.webSocketMessage((AtmosphereResource)r)) {
            return Action.CONTINUE;
        }
        AtmosphereRequest request = r.getRequest();
        String string = accept = request.getHeader("Accept") == null ? "text/plain" : request.getHeader("Accept").trim();
        if (r.transport().equals((Object)AtmosphereResource.TRANSPORT.SSE) || "text/event-stream".equalsIgnoreCase(accept)) {
            final AtmosphereResponse response = r.getResponse();
            if (response.getAsyncIOWriter() == null) {
                response.asyncIOWriter((AsyncIOWriter)new SseAtmosphereInterceptorWriter());
            }
            r.addEventListener((AtmosphereResourceEventListener)new P(response));
            AsyncIOWriter writer = response.getAsyncIOWriter();
            if (AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) {
                ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor((AsyncIOInterceptor)new AsyncIOInterceptorAdapter(){

                    private boolean padding() {
                        if (!r.isSuspended()) {
                            return SseAtmosphereInterceptor.this.writePadding(response);
                        }
                        return false;
                    }

                    public void prePayload(AtmosphereResponse response2, byte[] data, int offset, int length) {
                        this.padding();
                    }

                    public void postPayload(AtmosphereResponse response2, byte[] data, int offset, int length) {
                        String ua;
                        if (r.isSuspended() || r.getRequest().getAttribute(FrameworkConfig.CALLBACK_JAVASCRIPT_PROTOCOL) != null || r.getRequest().getAttribute("org.atmosphere.jersey.containerResponse") != null) {
                            response2.write(END, true);
                        }
                        if ((ua = r.getRequest().getHeader("User-Agent")) != null && ua.contains("MSIE")) {
                            try {
                                response2.flushBuffer();
                            }
                            catch (IOException e) {
                                LOG.log(Level.FINEST, "", e);
                            }
                            r.resume();
                        }
                    }
                });
            } else {
                LOG.warning(String.format("Unable to apply %s. Your AsyncIOWriter must implement %s", ((Object)((Object)this)).getClass().getName(), AtmosphereInterceptorWriter.class.getName()));
            }
        }
        return Action.CONTINUE;
    }

    static {
        END = "\r\n\r\n".getBytes();
        StringBuffer whitespace = new StringBuffer();
        for (int i = 0; i < 2000; ++i) {
            whitespace.append(" ");
        }
        whitespace.append("\n");
        PADDING_TEXT = whitespace.toString();
        PADDING = PADDING_TEXT.getBytes();
    }

    private final class P
    extends AtmosphereResourceEventListenerAdapter.OnPreSuspend
    implements AllowInterceptor {
        private final AtmosphereResponse response;

        private P(AtmosphereResponse response) {
            this.response = response;
        }

        public void onPreSuspend(AtmosphereResourceEvent event) {
            SseAtmosphereInterceptor.this.writePadding(this.response);
        }
    }
}

