/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.sse;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.SseBroadcaster;
import javax.ws.rs.sse.SseEventSink;

public class SseBroadcasterImpl
implements SseBroadcaster {
    private final Set<SseEventSink> subscribers = new CopyOnWriteArraySet<SseEventSink>();
    private final Set<Consumer<SseEventSink>> closers = new CopyOnWriteArraySet<Consumer<SseEventSink>>();
    private final Set<BiConsumer<SseEventSink, Throwable>> exceptioners = new CopyOnWriteArraySet<BiConsumer<SseEventSink, Throwable>>();

    public void register(SseEventSink sink) {
        this.subscribers.add(sink);
    }

    public CompletionStage<?> broadcast(OutboundSseEvent event) {
        ArrayList futures = new ArrayList();
        for (SseEventSink sink : this.subscribers) {
            try {
                futures.add(sink.send(event).toCompletableFuture());
            }
            catch (Exception ex) {
                this.exceptioners.forEach(exceptioner -> exceptioner.accept(sink, ex));
            }
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
    }

    public void onClose(Consumer<SseEventSink> subscriber) {
        this.closers.add(subscriber);
    }

    public void onError(BiConsumer<SseEventSink, Throwable> exceptioner) {
        this.exceptioners.add(exceptioner);
    }

    public void close() {
        this.subscribers.forEach(subscriber -> {
            subscriber.close();
            this.closers.forEach(closer -> closer.accept(subscriber));
        });
    }
}

