/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.constituency.parser.util;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.parser.Parse;
import opennlp.tools.util.Span;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.syntax.PunctuationToken;
import org.apache.ctakes.typesystem.type.syntax.TerminalTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TopTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.ctakes.utils.tree.SimpleTree;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.StringArray;

public class TreeUtils {
    public static List<TreebankNode> getNodeList(TopTreebankNode tree) {
        ArrayList<TreebankNode> list = new ArrayList<TreebankNode>();
        list.add((TreebankNode)tree);
        for (int ind = 0; ind < list.size(); ++ind) {
            TreebankNode cur = list.get(ind);
            for (int i = 0; i < cur.getChildren().size(); ++i) {
                list.add(cur.getChildren(i));
            }
        }
        return list;
    }

    public static List<Parse> getNodeList(Parse tree) {
        ArrayList<Parse> list = new ArrayList<Parse>();
        list.add(tree);
        for (int ind = 0; ind < list.size(); ++ind) {
            Parse cur = list.get(ind);
            Parse[] children = cur.getChildren();
            for (int i = 0; i < children.length; ++i) {
                list.add(children[i]);
            }
        }
        return list;
    }

    public static String tree2str(TreebankNode pathTree) {
        StringBuffer buff = new StringBuffer();
        buff.append("(");
        try {
            buff.append(pathTree.getNodeType());
        }
        catch (Exception e) {
            System.err.println("Caught NPE");
        }
        if (pathTree.getLeaf()) {
            buff.append(" ");
            buff.append(pathTree.getNodeValue());
        } else {
            for (int i = 0; i < pathTree.getChildren().size(); ++i) {
                buff.append(" ");
                buff.append(TreeUtils.tree2str(pathTree.getChildren(i)));
            }
        }
        buff.append(")");
        return buff.toString();
    }

    public static boolean containsIgnoreCase(SimpleTree node, SimpleTree frag) {
        return TreeUtils.contains(node, frag, true);
    }

    public static boolean contains(SimpleTree node, SimpleTree frag) {
        return TreeUtils.contains(node, frag, false);
    }

    public static boolean contains(SimpleTree node, SimpleTree frag, boolean ignoreCase) {
        if (TreeUtils.fragmentMatch(node, frag, ignoreCase)) {
            return true;
        }
        for (int i = 0; i < node.children.size(); ++i) {
            if (!TreeUtils.contains((SimpleTree)node.children.get(i), frag, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    private static boolean fragmentMatch(SimpleTree node, SimpleTree frag, boolean ignoreCase) {
        boolean same = false;
        if ((ignoreCase && node.cat.equalsIgnoreCase(frag.cat) || !ignoreCase && node.cat.equals(frag.cat)) && (frag.children.size() == 0 || node.children.size() == frag.children.size())) {
            same = true;
            for (int i = 0; i < frag.children.size(); ++i) {
                if (TreeUtils.fragmentMatch((SimpleTree)node.children.get(i), (SimpleTree)frag.children.get(i), ignoreCase)) continue;
                same = false;
                break;
            }
        }
        return same;
    }

    public static int getHighestIndexTerm(TreebankNode inTree) {
        if (inTree instanceof TerminalTreebankNode) {
            return ((TerminalTreebankNode)inTree).getIndex();
        }
        return TreeUtils.getHighestIndexTerm(inTree.getChildren(inTree.getChildren().size() - 1));
    }

    public static TopTreebankNode getTopNode(TreebankNode inTree) {
        TreebankNode cur = inTree;
        TopTreebankNode top = null;
        while (!(cur instanceof TopTreebankNode)) {
            cur = cur.getParent();
        }
        top = (TopTreebankNode)cur;
        return top;
    }

    public static TopTreebankNode buildAlignedTree(JCas jcas, Parse parse, Sentence sent) throws AnalysisEngineProcessException {
        FSArray termArray = TreeUtils.getTerminals(jcas, sent);
        StringBuffer parseBuff = new StringBuffer();
        if (parse != null) {
            parse.show(parseBuff);
        }
        TopTreebankNode top = new TopTreebankNode(jcas, sent.getBegin(), sent.getEnd());
        top.setTreebankParse(parseBuff.toString());
        top.setTerminals(termArray);
        top.setParent(null);
        if (parse != null) {
            TreeUtils.recursivelyCreateStructure(jcas, (TreebankNode)top, parse, top);
        }
        return top;
    }

    public static FSArray getTerminals(JCas jcas, Sentence sent) {
        ArrayList<BaseToken> wordList = new ArrayList<BaseToken>();
        FSIterator iterator = jcas.getAnnotationIndex(BaseToken.type).subiterator((AnnotationFS)sent);
        while (iterator.hasNext()) {
            BaseToken w = (BaseToken)iterator.next();
            if (w instanceof NewlineToken) continue;
            wordList.add(w);
        }
        FSArray terms = new FSArray(jcas, wordList.size());
        for (int i = 0; i < wordList.size(); ++i) {
            BaseToken w = (BaseToken)wordList.get(i);
            TerminalTreebankNode ttn = new TerminalTreebankNode(jcas, w.getBegin(), w.getEnd());
            ttn.setChildren(null);
            ttn.setIndex(i);
            ttn.setTokenIndex(i);
            ttn.setLeaf(true);
            ttn.setNodeTags(null);
            if (w instanceof PunctuationToken) {
                String tokStr = w.getCoveredText();
                if (tokStr.equals("(") || tokStr.equals("[")) {
                    ttn.setNodeValue("-LRB-");
                } else if (tokStr.equals(")") || tokStr.equals("]")) {
                    ttn.setNodeValue("-RRB-");
                } else if (tokStr.equals("{")) {
                    ttn.setNodeValue("-LCB-");
                } else if (tokStr.equals("}")) {
                    ttn.setNodeValue("-RCB-");
                } else {
                    ttn.setNodeValue(w.getCoveredText());
                }
            } else {
                ttn.setNodeValue(w.getCoveredText());
            }
            terms.set(i, (FeatureStructure)ttn);
        }
        return terms;
    }

    public static String getSentence(FSArray termArray) {
        StringBuffer sent = new StringBuffer();
        for (int i = 0; i < termArray.size(); ++i) {
            TerminalTreebankNode ttn = (TerminalTreebankNode)termArray.get(i);
            String word = ttn.getNodeValue();
            if ((word = word.replaceAll("\\s", "")).length() == 0) continue;
            sent.append(" ");
            sent.append(word);
        }
        return sent.toString();
    }

    private static void recursivelyCreateStructure(JCas jcas, TreebankNode parent, Parse parse, TopTreebankNode root) throws AnalysisEngineProcessException {
        String[] typeParts = parse.getType().startsWith("-") ? new String[]{parse.getType()} : parse.getType().split("-");
        parent.setNodeType(typeParts[0]);
        parent.setNodeValue(null);
        parent.setLeaf(parse.getChildCount() == 0);
        StringArray tags = new StringArray(jcas, typeParts.length - 1);
        for (int i = 1; i < typeParts.length; ++i) {
            tags.set(i - 1, typeParts[i]);
        }
        parent.setNodeTags(tags);
        parent.setHeadIndex(parse.getHeadIndex());
        Parse[] subtrees = parse.getChildren();
        FSArray children = new FSArray(jcas, subtrees.length);
        for (int i = 0; i < subtrees.length; ++i) {
            Parse subtree = subtrees[i];
            if (subtree.getChildCount() == 1 && subtree.getChildren()[0].getChildCount() == 0) {
                TerminalTreebankNode term = root.getTerminals(subtree.getHeadIndex());
                term.setNodeType(subtree.getType());
                children.set(i, (FeatureStructure)term);
                term.setParent(parent);
                term.addToIndexes();
                continue;
            }
            try {
                TreebankNode child = new TreebankNode(jcas);
                child.setParent(parent);
                children.set(i, (FeatureStructure)child);
                TreeUtils.recursivelyCreateStructure(jcas, child, subtree, root);
                child.addToIndexes();
                continue;
            }
            catch (NullPointerException e) {
                System.err.println("MaxentParserWrapper Error: " + e);
                throw new AnalysisEngineProcessException();
            }
        }
        parent.setBegin(((TreebankNode)children.get(0)).getBegin());
        parent.setEnd(((TreebankNode)children.get(subtrees.length - 1)).getEnd());
        parent.setChildren(children);
    }

    public static void replaceChild(TreebankNode parent, TreebankNode oldTree, TreebankNode newTree) {
        if (parent != null) {
            for (int i = 0; i < parent.getChildren().size(); ++i) {
                if (parent.getChildren(i) != oldTree) continue;
                parent.setChildren(i, newTree);
            }
        }
    }

    public static Parse ctakesTokensToOpennlpTokens(Sentence sent, FSArray termArray) {
        String text = sent.getCoveredText();
        Parse p = new Parse(sent.getCoveredText(), new Span(0, text.length()), "INC", 0.0, 0);
        for (int i = 0; i < termArray.size(); ++i) {
            TerminalTreebankNode token = (TerminalTreebankNode)termArray.get(i);
            p.insert(new Parse(text, new Span(token.getBegin() - sent.getBegin(), token.getEnd() - sent.getBegin()), "TK", 0.0, i));
        }
        return p;
    }
}

