/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.constituency.parser.treekernel;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import opennlp.tools.parser.Parse;
import org.apache.ctakes.constituency.parser.util.TreeUtils;
import org.apache.ctakes.utils.kernel.Kernel;

public class TreeKernel
extends Kernel {
    public static double lambda = 0.4;
    public static double lambdaSquared = lambda * lambda;
    private ConcurrentHashMap<String, Double> normalizers = new ConcurrentHashMap();
    private int normalHits = 0;
    private boolean normalize = false;

    public TreeKernel() {
        this(false);
    }

    public TreeKernel(boolean norm) {
        this.normalize = norm;
    }

    public double eval(Object o1, Object o2) {
        Parse node1 = (Parse)o1;
        Parse node2 = (Parse)o2;
        double norm1 = 0.0;
        double norm2 = 0.0;
        if (this.normalize) {
            StringBuffer nodeStr = new StringBuffer();
            node1.show(nodeStr);
            String node1Str = nodeStr.toString();
            if (!this.normalizers.containsKey(node1Str)) {
                double norm = this.sim(node1, node1);
                System.out.println(node1Str);
                this.normalizers.put(node1Str, norm);
                ++this.normalHits;
            }
            nodeStr = new StringBuffer();
            node2.show(nodeStr);
            String node2Str = nodeStr.toString();
            if (!this.normalizers.containsKey(node2Str)) {
                double norm = this.sim(node2, node2);
                this.normalizers.put(node2Str, norm);
                ++this.normalHits;
            }
            norm1 = this.normalizers.get(node1Str);
            norm2 = this.normalizers.get(node2Str);
        }
        if (this.normalize) {
            return this.sim(node1, node2) / Math.sqrt(norm1 * norm2);
        }
        return this.sim(node1, node2);
    }

    private double sim(Parse node1, Parse node2) {
        double sim = 0.0;
        List<Parse> N1 = TreeUtils.getNodeList(node1);
        List<Parse> N2 = TreeUtils.getNodeList(node2);
        for (Parse n1 : N1) {
            for (Parse n2 : N2) {
                double cm = 0.0;
                cm = TreeKernel.numCommonSubtrees(n1, n2);
                sim += cm;
            }
        }
        return sim;
    }

    private static double numCommonSubtrees(Parse n1, Parse n2) {
        double retVal = 1.0;
        if (n1.getChildCount() != n2.getChildCount()) {
            retVal = 0.0;
        } else if (!n1.getType().equals(n2.getType())) {
            retVal = 0.0;
        } else if (n1.getChildCount() == 1 && n1.getChildren()[0].getChildCount() == 0 && n2.getChildren()[0].getChildCount() == 0) {
            retVal = lambdaSquared;
        } else {
            int i;
            boolean sameProd = true;
            for (i = 0; i < n1.getChildCount(); ++i) {
                String l2;
                String l1 = n1.getChildren()[i].getType();
                if (l1.equals(l2 = n2.getChildren()[i].getType())) continue;
                sameProd = false;
                break;
            }
            if (sameProd) {
                for (i = 0; i < n1.getChildCount(); ++i) {
                    retVal *= 1.0 + TreeKernel.numCommonSubtrees(n1.getChildren()[i], n2.getChildren()[i]);
                }
                retVal = lambdaSquared * retVal;
            } else {
                retVal = 0.0;
            }
        }
        return retVal;
    }
}

