/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.scrunch;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.Stringable;
import org.apache.avro.reflect.Union;
import org.apache.avro.specific.FixedSize;
import org.codehaus.jackson.node.NullNode;
import scala.collection.Iterable;
import scala.collection.Map;

public class ScalaSafeReflectData
extends ReflectData.AllowNull {
    private static final ScalaSafeReflectData INSTANCE = new ScalaSafeReflectData();
    static final String CLASS_PROP = "java-class";
    static final String ELEMENT_PROP = "java-element-class";
    private static final Schema THROWABLE_MESSAGE = ScalaSafeReflectData.makeNullable((Schema)Schema.create((Schema.Type)Schema.Type.STRING));
    private static final java.util.Map<Class, java.util.Map<String, Field>> FIELD_CACHE = new ConcurrentHashMap<Class, java.util.Map<String, Field>>();

    public static ScalaSafeReflectData get() {
        return INSTANCE;
    }

    static Class getClassProp(Schema schema, String prop) {
        String name = schema.getProp(prop);
        if (name == null) {
            return null;
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new AvroRuntimeException((Throwable)e);
        }
    }

    private String getSimpleName(Class clazz) {
        try {
            return ScalaSafeReflectData.clean(clazz.getSimpleName());
        }
        catch (InternalError ie) {
            String fullName = clazz.getName();
            String[] pieces = fullName.split("\\.");
            return ScalaSafeReflectData.clean(pieces[pieces.length - 1]);
        }
    }

    protected Schema createSchema(Type type, java.util.Map<String, Schema> names) {
        if (type instanceof GenericArrayType) {
            Type component = ((GenericArrayType)type).getGenericComponentType();
            if (component == Byte.TYPE) {
                return Schema.create((Schema.Type)Schema.Type.BYTES);
            }
            Schema result = Schema.createArray((Schema)this.createSchema(component, names));
            this.setElement(result, component);
            return result;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Class raw = (Class)ptype.getRawType();
            Type[] params = ptype.getActualTypeArguments();
            if (java.util.Map.class.isAssignableFrom(raw) || Map.class.isAssignableFrom(raw)) {
                Type key = params[0];
                Type value2 = params[1];
                if (key != String.class) {
                    throw new AvroTypeException("Map key class not String: " + key);
                }
                Schema schema = Schema.createMap((Schema)this.createSchema(value2, names));
                schema.addProp(CLASS_PROP, raw.getName());
                return schema;
            }
            if (Collection.class.isAssignableFrom(raw) || Iterable.class.isAssignableFrom(raw)) {
                if (params.length != 1) {
                    throw new AvroTypeException("No array type specified.");
                }
                Schema schema = Schema.createArray((Schema)this.createSchema(params[0], names));
                schema.addProp(CLASS_PROP, raw.getName());
                return schema;
            }
            throw new AvroTypeException("Could not convert type: " + type);
        }
        if (type == Short.class || type == Short.TYPE) {
            Schema result = Schema.create((Schema.Type)Schema.Type.INT);
            result.addProp(CLASS_PROP, Short.class.getName());
            return result;
        }
        if (type instanceof Class) {
            Class c = (Class)type;
            if (c.isPrimitive() || Number.class.isAssignableFrom(c) || c == Void.class || c == Boolean.class) {
                return super.createSchema(type, names);
            }
            if (c.isArray()) {
                Class<?> component = c.getComponentType();
                if (component == Byte.TYPE) {
                    return Schema.create((Schema.Type)Schema.Type.BYTES);
                }
                Schema result = Schema.createArray((Schema)this.createSchema(component, names));
                this.setElement(result, component);
                return result;
            }
            if (CharSequence.class.isAssignableFrom(c)) {
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
            String fullName = c.getName();
            Schema schema = names.get(fullName);
            if (schema == null) {
                Union union2;
                String space;
                String name = this.getSimpleName(c);
                String string = space = c.getPackage() == null ? "" : c.getPackage().getName();
                if (c.getEnclosingClass() != null) {
                    space = c.getEnclosingClass().getName() + "$";
                }
                if ((union2 = c.getAnnotation(Union.class)) != null) {
                    return this.getAnnotatedUnion(union2, names);
                }
                if (c.isAnnotationPresent(Stringable.class)) {
                    Schema result = Schema.create((Schema.Type)Schema.Type.STRING);
                    result.addProp(CLASS_PROP, c.getName());
                    return result;
                }
                if (c.isEnum()) {
                    ArrayList<String> symbols = new ArrayList<String>();
                    Enum[] constants = (Enum[])c.getEnumConstants();
                    for (int i = 0; i < constants.length; ++i) {
                        symbols.add(constants[i].name());
                    }
                    schema = Schema.createEnum((String)name, null, (String)space, symbols);
                } else if (GenericFixed.class.isAssignableFrom(c)) {
                    int size = c.getAnnotation(FixedSize.class).value();
                    schema = Schema.createFixed((String)name, null, (String)space, (int)size);
                } else {
                    if (IndexedRecord.class.isAssignableFrom(c)) {
                        return super.createSchema(type, names);
                    }
                    ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
                    boolean error = Throwable.class.isAssignableFrom(c);
                    schema = Schema.createRecord((String)name, null, (String)space, (boolean)error);
                    names.put(c.getName(), schema);
                    for (Field field : this.getFields(c)) {
                        Schema defaultType;
                        if ((field.getModifiers() & 0x88) != 0) continue;
                        Schema fieldSchema = this.createFieldSchema(field, names);
                        NullNode defaultValue = null;
                        if (fieldSchema.getType() == Schema.Type.UNION && (defaultType = (Schema)fieldSchema.getTypes().get(0)).getType() == Schema.Type.NULL) {
                            defaultValue = NullNode.getInstance();
                        }
                        fields.add(new Schema.Field(ScalaSafeReflectData.clean(field.getName()), fieldSchema, null, defaultValue));
                    }
                    if (error) {
                        fields.add(new Schema.Field("detailMessage", THROWABLE_MESSAGE, null, null));
                    }
                    schema.setFields(fields);
                }
                names.put(fullName, schema);
            }
            return schema;
        }
        return super.createSchema(type, names);
    }

    public Object getField(Object record, String name, int position) {
        if (record instanceof IndexedRecord) {
            return super.getField(record, name, position);
        }
        try {
            return ScalaSafeReflectData.getField(record.getClass(), name).get(record);
        }
        catch (IllegalAccessException e) {
            throw new AvroRuntimeException((Throwable)e);
        }
    }

    private static Field getField(Class c, String name) {
        Field f;
        java.util.Map<String, Field> fields = FIELD_CACHE.get(c);
        if (fields == null) {
            fields = new ConcurrentHashMap<String, Field>();
            FIELD_CACHE.put(c, fields);
        }
        if ((f = fields.get(name)) == null) {
            f = ScalaSafeReflectData.findField(c, name);
            fields.put(name, f);
        }
        return f;
    }

    private static Field findField(Class original, String name) {
        Class c = original;
        while (true) {
            try {
                Field f = c.getDeclaredField(ScalaSafeReflectData.dirty(name));
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if ((c = c.getSuperclass()) != null) continue;
                throw new AvroRuntimeException("No field named " + name + " in: " + original);
            }
            break;
        }
    }

    private static String clean(String dirty) {
        return dirty.replace('$', '_');
    }

    private static String dirty(String clean) {
        return clean.replace('_', '$');
    }

    private Collection<Field> getFields(Class recordClass) {
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        Class c = recordClass;
        while (c.getPackage() == null || !c.getPackage().getName().startsWith("java.")) {
            for (Field field : c.getDeclaredFields()) {
                if ((field.getModifiers() & 0x88) != 0 || fields.put(field.getName(), field) == null) continue;
                throw new AvroTypeException(c + " contains two fields named: " + field);
            }
            if ((c = c.getSuperclass()) != null) continue;
        }
        return fields.values();
    }

    private void setElement(Schema schema, Type element) {
        if (!(element instanceof Class)) {
            return;
        }
        Class c = (Class)element;
        Union union2 = c.getAnnotation(Union.class);
        if (union2 != null) {
            schema.addProp(ELEMENT_PROP, c.getName());
        }
    }

    private Schema getAnnotatedUnion(Union union2, java.util.Map<String, Schema> names) {
        ArrayList<Schema> branches = new ArrayList<Schema>();
        for (Class branch : union2.value()) {
            branches.add(this.createSchema(branch, names));
        }
        return Schema.createUnion(branches);
    }

    protected boolean isArray(Object datum) {
        if (datum == null) {
            return false;
        }
        return datum instanceof Collection || datum.getClass().isArray() || datum instanceof Iterable;
    }

    protected boolean isMap(Object datum) {
        return datum instanceof java.util.Map || datum instanceof Map;
    }
}

