/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.scrunch;

import com.google.common.collect.ImmutableList;
import com.twitter.algebird.Monoid;
import org.apache.crunch.Aggregator;
import org.apache.crunch.fn.Aggregators;
import org.apache.crunch.scrunch.Aggregators;
import scala.Array$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;

public final class Aggregators$ {
    public static final Aggregators$ MODULE$;

    static {
        new Aggregators$();
    }

    public <T> Aggregator<T> sum(Monoid<T> evidence$1) {
        return this.sumUsing((Monoid)Predef$.MODULE$.implicitly(evidence$1));
    }

    public <T> Aggregator<T> sumUsing(Monoid<T> m) {
        return new Aggregators.SimpleAggregator<T>(m){
            private T sum;
            private final Monoid m$1;

            public void reset() {
                this.sum_$eq(this.m$1.zero());
            }

            public void update(T next) {
                this.sum_$eq(this.m$1.plus(this.sum(), next));
            }

            public Iterable<T> results() {
                return ImmutableList.of(this.sum());
            }

            private T sum() {
                return this.sum;
            }

            private void sum_$eq(T x$1) {
                this.sum = x$1;
            }
            {
                this.m$1 = m$1;
                this.sum = m$1.zero();
            }
        };
    }

    public <T> Aggregators.SimpleAggregator<T> max(Ordering<T> evidence$2) {
        return new Aggregators.SimpleAggregator<T>(evidence$2){
            private Option<T> max;
            private final Ordering evidence$2$1;

            public void reset() {
                this.max_$eq((Option<T>)None$.MODULE$);
            }

            public void update(T next) {
                if (this.max().isEmpty() || ((Ordering)Predef$.MODULE$.implicitly((Object)this.evidence$2$1)).lt(this.max().get(), next)) {
                    this.max_$eq((Option<T>)new Some(next));
                }
            }

            public Iterable<T> results() {
                return JavaConversions$.MODULE$.asJavaIterable(Option$.MODULE$.option2Iterable(this.max()).toIterable());
            }

            private Option<T> max() {
                return this.max;
            }

            private void max_$eq(Option<T> x$1) {
                this.max = x$1;
            }
            {
                this.evidence$2$1 = evidence$2$1;
                this.max = None$.MODULE$;
            }
        };
    }

    public <T> Aggregators.SimpleAggregator<T> min(Ordering<T> evidence$3) {
        return new Aggregators.SimpleAggregator<T>(evidence$3){
            private Option<T> min;
            private final Ordering evidence$3$1;

            public void reset() {
                this.min_$eq((Option<T>)None$.MODULE$);
            }

            public void update(T next) {
                if (this.min().isEmpty() || ((Ordering)Predef$.MODULE$.implicitly((Object)this.evidence$3$1)).gt(this.min().get(), next)) {
                    this.min_$eq((Option<T>)new Some(next));
                }
            }

            public Iterable<T> results() {
                return JavaConversions$.MODULE$.asJavaIterable(Option$.MODULE$.option2Iterable(this.min()).toIterable());
            }

            private Option<T> min() {
                return this.min;
            }

            private void min_$eq(Option<T> x$1) {
                this.min = x$1;
            }
            {
                this.evidence$3$1 = evidence$3$1;
                this.min = None$.MODULE$;
            }
        };
    }

    public <V> Aggregator<V> first(int n) {
        return Aggregators.FIRST_N((int)n);
    }

    public <V> Aggregator<Nothing$> last(int n) {
        return Aggregators.LAST_N((int)n);
    }

    public Aggregator<String> concat(String separator, boolean skipNull) {
        return Aggregators.STRING_CONCAT((String)separator, (boolean)skipNull);
    }

    public Aggregator<String> concat(String separator, boolean skipNull, long maxOutputLength, long maxInputLength) {
        return Aggregators.STRING_CONCAT((String)separator, (boolean)skipNull, (long)maxOutputLength, (long)maxInputLength);
    }

    public <V> Aggregator<V> unique() {
        return Aggregators.UNIQUE_ELEMENTS();
    }

    public Aggregator<Nothing$> sampleUnique(int maximumSampleSize) {
        return Aggregators.SAMPLE_UNIQUE_ELEMENTS((int)maximumSampleSize);
    }

    public <V1, V2> Aggregator<Tuple2<V1, V2>> pair(Aggregator<V1> a1, Aggregator<V2> a2) {
        return new Aggregators.PairAggregator<V1, V2>(a1, a2);
    }

    public <V1, V2, V3> Aggregator<Tuple3<V1, V2, V3>> trip(Aggregator<V1> a1, Aggregator<V2> a2, Aggregator<V3> a3) {
        return new Aggregators.TripAggregator<V1, V2, V3>(a1, a2, a3);
    }

    public <V1, V2, V3, V4> Aggregator<Tuple4<V1, V2, V3, V4>> quad(Aggregator<V1> a1, Aggregator<V2> a2, Aggregator<V3> a3, Aggregator<V4> a4) {
        return new Aggregators.QuadAggregator<V1, V2, V3, V4>(a1, a2, a3, a4);
    }

    public <T extends Product> Aggregator<T> product(Seq<Aggregator<?>> aggregators, ClassTag<T> evidence$4) {
        return new Aggregators.ProductAggregator((Aggregator[])Array$.MODULE$.apply(aggregators, ClassTag$.MODULE$.apply(Aggregator.class)), ((ClassTag)Predef$.MODULE$.implicitly(evidence$4)).runtimeClass());
    }

    private Aggregators$() {
        MODULE$ = this;
    }
}

