/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.scrunch;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.avro.Schema;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.crunch.scrunch.ScalaSafeReflectData;
import org.apache.hadoop.util.ReflectionUtils;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;

public class ScalaSafeReflectDatumReader<T>
extends ReflectDatumReader<T> {
    public ScalaSafeReflectDatumReader(Schema schema) {
        super(schema, schema, (ReflectData)ScalaSafeReflectData.get());
    }

    protected Object readArray(Object old, Schema expected, ResolvingDecoder in) throws IOException {
        Schema expectedType = expected.getElementType();
        long l = in.readArrayStart();
        long base = 0L;
        if (l > 0L) {
            Object array = this.newArray(old, (int)l, expected);
            do {
                for (long i = 0L; i < l; ++i) {
                    this.addToArray(array, base + i, this.read(this.peekArray(array), expectedType, in));
                }
                base += l;
            } while ((l = in.arrayNext()) > 0L);
            return ScalaSafeReflectDatumReader.scalaIterableCheck(array, expected);
        }
        return ScalaSafeReflectDatumReader.scalaIterableCheck(this.newArray(old, 0, expected), expected);
    }

    protected Object readMap(Object old, Schema expected, ResolvingDecoder in) throws IOException {
        return ScalaSafeReflectDatumReader.scalaMapCheck(super.readMap(old, expected, in), expected);
    }

    public static Object scalaMapCheck(Object map, Schema schema) {
        Class mapClass = ScalaSafeReflectData.getClassProp(schema, "java-class");
        if (mapClass != null && mapClass.isAssignableFrom(Map.class)) {
            return JavaConversions.mapAsScalaMap((java.util.Map)((java.util.Map)map));
        }
        return map;
    }

    public static Object scalaIterableCheck(Object array, Schema schema) {
        Class collectionClass = ScalaSafeReflectData.getClassProp(schema, "java-class");
        if (collectionClass != null && Iterable.class.isAssignableFrom(collectionClass)) {
            Iterable it = ScalaSafeReflectDatumReader.toIter(array);
            if (List.class.isAssignableFrom(collectionClass)) {
                return it.toList();
            }
            if (Buffer.class.isAssignableFrom(collectionClass)) {
                return it.toBuffer();
            }
            if (Set.class.isAssignableFrom(collectionClass)) {
                return it.toSet();
            }
            return it;
        }
        return array;
    }

    private static Iterable toIter(Object array) {
        return JavaConversions.collectionAsScalaIterable((Collection)((Collection)array));
    }

    protected Object newArray(Object old, int size, Schema schema) {
        ScalaSafeReflectData data = ScalaSafeReflectData.get();
        Class collectionClass = ScalaSafeReflectData.getClassProp(schema, "java-class");
        if (collectionClass != null) {
            if (old instanceof Collection) {
                ((Collection)old).clear();
                return old;
            }
            if (Iterable.class.isAssignableFrom(collectionClass) || collectionClass.isAssignableFrom(ArrayList.class)) {
                return new ArrayList();
            }
            return ReflectionUtils.newInstance((Class)collectionClass, null);
        }
        Class elementClass = ScalaSafeReflectData.getClassProp(schema, "java-element-class");
        if (elementClass == null) {
            elementClass = data.getClass(schema.getElementType());
        }
        return Array.newInstance(elementClass, size);
    }
}

