/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.simple;

import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.simple.RandomSource;

public final class ThreadLocalRandomSource {
    private static final Map<RandomSource, ThreadLocal<UniformRandomProvider>> SOURCES = new EnumMap<RandomSource, ThreadLocal<UniformRandomProvider>>(RandomSource.class);

    private ThreadLocalRandomSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UniformRandomProvider current(RandomSource source) {
        ThreadLocal rng = SOURCES.get((Object)source);
        if (rng == null) {
            if (source == null) {
                throw new IllegalArgumentException("Random source is null");
            }
            Map<RandomSource, ThreadLocal<UniformRandomProvider>> map = SOURCES;
            synchronized (map) {
                rng = SOURCES.computeIfAbsent(source, ThreadLocalRng::new);
            }
        }
        return rng.get();
    }

    private static class ThreadLocalRng
    extends ThreadLocal<UniformRandomProvider> {
        private final RandomSource source;

        ThreadLocalRng(RandomSource source) {
            this.source = source;
        }

        @Override
        protected UniformRandomProvider initialValue() {
            return this.source.create();
        }
    }
}

