/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.fraction.Fraction;
import org.apache.commons.math3.fraction.FractionConversionException;
import org.apache.commons.math3.fraction.FractionField;
import org.apache.commons.math3.util.OpenIntToFieldHashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenIntToFieldTest {
    private Map<Integer, Fraction> javaMap = new HashMap<Integer, Fraction>();
    private FractionField field = FractionField.getInstance();

    @Before
    public void setUp() throws FractionConversionException {
        this.javaMap.put(50, new Fraction(100.0));
        this.javaMap.put(75, new Fraction(75.0));
        this.javaMap.put(25, new Fraction(500.0));
        this.javaMap.put(Integer.MAX_VALUE, new Fraction(Integer.MAX_VALUE));
        this.javaMap.put(0, new Fraction(-1.0));
        this.javaMap.put(1, new Fraction(0.0));
        this.javaMap.put(33, new Fraction(-0.1));
        this.javaMap.put(23234234, new Fraction(-242343.0));
        this.javaMap.put(23321, new Fraction(Integer.MIN_VALUE));
        this.javaMap.put(-4444, new Fraction(332.0));
        this.javaMap.put(-1, new Fraction(-2323.0));
        this.javaMap.put(Integer.MIN_VALUE, new Fraction(44.0));
        this.javaMap.putAll(this.generate());
    }

    private Map<Integer, Fraction> generate() {
        HashMap<Integer, Fraction> map = new HashMap<Integer, Fraction>();
        Random r = new Random();
        double dd = 0.0;
        for (int i = 0; i < 2000; ++i) {
            dd = r.nextDouble();
        }
        try {
            map.put(r.nextInt(), new Fraction(dd));
        }
        catch (FractionConversionException e) {
            throw new IllegalStateException("Invalid :" + dd, e);
        }
        return map;
    }

    private OpenIntToFieldHashMap<Fraction> createFromJavaMap(Field<Fraction> field) {
        OpenIntToFieldHashMap map = new OpenIntToFieldHashMap(field);
        for (Map.Entry<Integer, Fraction> mapEntry : this.javaMap.entrySet()) {
            map.put(mapEntry.getKey().intValue(), (FieldElement)mapEntry.getValue());
        }
        return map;
    }

    @Test
    public void testPutAndGetWith0ExpectedSize() {
        OpenIntToFieldHashMap map = new OpenIntToFieldHashMap((Field)this.field, 0);
        this.assertPutAndGet((OpenIntToFieldHashMap<Fraction>)map);
    }

    @Test
    public void testPutAndGetWithExpectedSize() {
        OpenIntToFieldHashMap map = new OpenIntToFieldHashMap((Field)this.field, 500);
        this.assertPutAndGet((OpenIntToFieldHashMap<Fraction>)map);
    }

    @Test
    public void testPutAndGet() {
        OpenIntToFieldHashMap map = new OpenIntToFieldHashMap((Field)this.field);
        this.assertPutAndGet((OpenIntToFieldHashMap<Fraction>)map);
    }

    private void assertPutAndGet(OpenIntToFieldHashMap<Fraction> map) {
        this.assertPutAndGet(map, 0, new HashSet<Integer>());
    }

    private void assertPutAndGet(OpenIntToFieldHashMap<Fraction> map, int mapSize, Set<Integer> keysInMap) {
        Assert.assertEquals((long)mapSize, (long)map.size());
        for (Map.Entry<Integer, Fraction> mapEntry : this.javaMap.entrySet()) {
            map.put(mapEntry.getKey().intValue(), (FieldElement)mapEntry.getValue());
            if (!keysInMap.contains(mapEntry.getKey())) {
                ++mapSize;
            }
            Assert.assertEquals((long)mapSize, (long)map.size());
            Assert.assertEquals((Object)mapEntry.getValue(), (Object)map.get(mapEntry.getKey().intValue()));
        }
    }

    @Test
    public void testPutAbsentOnExisting() {
        OpenIntToFieldHashMap<Fraction> map = this.createFromJavaMap((Field<Fraction>)this.field);
        int size = this.javaMap.size();
        for (Map.Entry<Integer, Fraction> mapEntry : this.generateAbsent().entrySet()) {
            map.put(mapEntry.getKey().intValue(), (FieldElement)mapEntry.getValue());
            Assert.assertEquals((long)(++size), (long)map.size());
            Assert.assertEquals((Object)mapEntry.getValue(), (Object)map.get(mapEntry.getKey().intValue()));
        }
    }

    @Test
    public void testPutOnExisting() {
        OpenIntToFieldHashMap<Fraction> map = this.createFromJavaMap((Field<Fraction>)this.field);
        for (Map.Entry<Integer, Fraction> mapEntry : this.javaMap.entrySet()) {
            map.put(mapEntry.getKey().intValue(), (FieldElement)mapEntry.getValue());
            Assert.assertEquals((long)this.javaMap.size(), (long)map.size());
            Assert.assertEquals((Object)mapEntry.getValue(), (Object)map.get(mapEntry.getKey().intValue()));
        }
    }

    @Test
    public void testGetAbsent() {
        Map<Integer, Fraction> generated = this.generateAbsent();
        OpenIntToFieldHashMap<Fraction> map = this.createFromJavaMap((Field<Fraction>)this.field);
        for (Map.Entry<Integer, Fraction> mapEntry : generated.entrySet()) {
            Assert.assertTrue((boolean)this.field.getZero().equals((Object)map.get(mapEntry.getKey().intValue())));
        }
    }

    @Test
    public void testGetFromEmpty() {
        OpenIntToFieldHashMap map = new OpenIntToFieldHashMap((Field)this.field);
        Assert.assertTrue((boolean)this.field.getZero().equals((Object)map.get(5)));
        Assert.assertTrue((boolean)this.field.getZero().equals((Object)map.get(0)));
        Assert.assertTrue((boolean)this.field.getZero().equals((Object)map.get(50)));
    }

    @Test
    public void testRemove() {
        OpenIntToFieldHashMap<Fraction> map = this.createFromJavaMap((Field<Fraction>)this.field);
        int mapSize = this.javaMap.size();
        Assert.assertEquals((long)mapSize, (long)map.size());
        for (Map.Entry<Integer, Fraction> mapEntry : this.javaMap.entrySet()) {
            map.remove(mapEntry.getKey().intValue());
            Assert.assertEquals((long)(--mapSize), (long)map.size());
            Assert.assertTrue((boolean)this.field.getZero().equals((Object)map.get(mapEntry.getKey().intValue())));
        }
        this.assertPutAndGet(map);
    }

    @Test
    public void testRemove2() {
        OpenIntToFieldHashMap<Fraction> map = this.createFromJavaMap((Field<Fraction>)this.field);
        int mapSize = this.javaMap.size();
        int count = 0;
        HashSet<Integer> keysInMap = new HashSet<Integer>(this.javaMap.keySet());
        for (Map.Entry<Integer, Fraction> mapEntry : this.javaMap.entrySet()) {
            keysInMap.remove(mapEntry.getKey());
            map.remove(mapEntry.getKey().intValue());
            Assert.assertEquals((long)(--mapSize), (long)map.size());
            Assert.assertTrue((boolean)this.field.getZero().equals((Object)map.get(mapEntry.getKey().intValue())));
            if (count++ <= 5) continue;
            break;
        }
        this.assertPutAndGet(map, mapSize, keysInMap);
    }

    @Test
    public void testRemoveFromEmpty() {
        OpenIntToFieldHashMap map = new OpenIntToFieldHashMap((Field)this.field);
        Assert.assertTrue((boolean)this.field.getZero().equals((Object)map.remove(50)));
    }

    @Test
    public void testRemoveAbsent() {
        Map<Integer, Fraction> generated = this.generateAbsent();
        OpenIntToFieldHashMap<Fraction> map = this.createFromJavaMap((Field<Fraction>)this.field);
        int mapSize = map.size();
        for (Map.Entry<Integer, Fraction> mapEntry : generated.entrySet()) {
            map.remove(mapEntry.getKey().intValue());
            Assert.assertEquals((long)mapSize, (long)map.size());
            Assert.assertTrue((boolean)this.field.getZero().equals((Object)map.get(mapEntry.getKey().intValue())));
        }
    }

    private Map<Integer, Fraction> generateAbsent() {
        HashMap<Integer, Fraction> generated = new HashMap<Integer, Fraction>();
        do {
            generated.putAll(this.generate());
            for (Integer key : this.javaMap.keySet()) {
                generated.remove(key);
            }
        } while (generated.size() < 100);
        return generated;
    }

    @Test
    public void testCopy() {
        OpenIntToFieldHashMap copy = new OpenIntToFieldHashMap(this.createFromJavaMap((Field<Fraction>)this.field));
        Assert.assertEquals((long)this.javaMap.size(), (long)copy.size());
        for (Map.Entry<Integer, Fraction> mapEntry : this.javaMap.entrySet()) {
            Assert.assertEquals((Object)mapEntry.getValue(), (Object)copy.get(mapEntry.getKey().intValue()));
        }
    }

    @Test
    public void testContainsKey() {
        OpenIntToFieldHashMap<Fraction> map = this.createFromJavaMap((Field<Fraction>)this.field);
        for (Map.Entry<Integer, Fraction> mapEntry : this.javaMap.entrySet()) {
            Assert.assertTrue((boolean)map.containsKey(mapEntry.getKey().intValue()));
        }
        for (Map.Entry<Integer, Fraction> mapEntry : this.generateAbsent().entrySet()) {
            Assert.assertFalse((boolean)map.containsKey(mapEntry.getKey().intValue()));
        }
        for (Map.Entry<Integer, Fraction> mapEntry : this.javaMap.entrySet()) {
            int key = mapEntry.getKey();
            Assert.assertTrue((boolean)map.containsKey(key));
            map.remove(key);
            Assert.assertFalse((boolean)map.containsKey(key));
        }
    }

    @Test
    public void testIterator() {
        OpenIntToFieldHashMap<Fraction> map = this.createFromJavaMap((Field<Fraction>)this.field);
        OpenIntToFieldHashMap.Iterator iterator = map.iterator();
        for (int i = 0; i < map.size(); ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            iterator.advance();
            int key = iterator.key();
            Assert.assertTrue((boolean)map.containsKey(key));
            Assert.assertEquals((Object)this.javaMap.get(key), (Object)map.get(key));
            Assert.assertEquals((Object)this.javaMap.get(key), (Object)iterator.value());
            Assert.assertTrue((boolean)this.javaMap.containsKey(key));
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.advance();
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentModification() {
        OpenIntToFieldHashMap<Fraction> map = this.createFromJavaMap((Field<Fraction>)this.field);
        OpenIntToFieldHashMap.Iterator iterator = map.iterator();
        map.put(3, (FieldElement)new Fraction(3));
        try {
            iterator.advance();
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @Test
    public void testPutKeysWithCollisions() {
        OpenIntToFieldHashMap map = new OpenIntToFieldHashMap((Field)this.field);
        int key1 = -1996012590;
        Fraction value1 = new Fraction(1);
        map.put(key1, (FieldElement)value1);
        int key2 = 835099822;
        map.put(key2, (FieldElement)value1);
        int key3 = 1008859686;
        map.put(key3, (FieldElement)value1);
        Assert.assertEquals((Object)value1, (Object)map.get(key3));
        Assert.assertEquals((long)3L, (long)map.size());
        map.remove(key2);
        Fraction value2 = new Fraction(2);
        map.put(key3, (FieldElement)value2);
        Assert.assertEquals((Object)value2, (Object)map.get(key3));
        Assert.assertEquals((long)2L, (long)map.size());
    }

    @Test
    public void testPutKeysWithCollision2() {
        OpenIntToFieldHashMap map = new OpenIntToFieldHashMap((Field)this.field);
        int key1 = 837989881;
        Fraction value1 = new Fraction(1);
        map.put(key1, (FieldElement)value1);
        int key2 = 476463321;
        map.put(key2, (FieldElement)value1);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)value1, (Object)map.get(key2));
        map.remove(key1);
        Fraction value2 = new Fraction(2);
        map.put(key2, (FieldElement)value2);
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)value2, (Object)map.get(key2));
    }
}

