/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.interval;

import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.stat.interval.BinomialConfidenceInterval;
import org.apache.commons.math3.stat.interval.ConfidenceInterval;
import org.junit.Before;
import org.junit.Test;

public abstract class BinomialConfidenceIntervalAbstractTest {
    protected BinomialConfidenceInterval testStatistic;
    private final int successes = 50;
    private final int trials = 500;
    private final double confidenceLevel = 0.9;

    protected abstract BinomialConfidenceInterval createBinomialConfidenceInterval();

    protected ConfidenceInterval createStandardTestInterval() {
        return this.testStatistic.createInterval(500, 50, 0.9);
    }

    @Before
    public void setUp() {
        this.testStatistic = this.createBinomialConfidenceInterval();
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testZeroConfidencelevel() {
        this.testStatistic.createInterval(500, 50, 0.0);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testOneConfidencelevel() {
        this.testStatistic.createInterval(500, 50, 1.0);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testZeroTrials() {
        this.testStatistic.createInterval(0, 0, 0.9);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testNegativeSuccesses() {
        this.testStatistic.createInterval(500, -1, 0.9);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testSuccessesExceedingTrials() {
        this.testStatistic.createInterval(500, 501, 0.9);
    }
}

