/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import org.apache.commons.math3.ode.TestProblemAbstract;
import org.apache.commons.math3.util.FastMath;

public class TestProblem3
extends TestProblemAbstract {
    double e;
    private double[] y;

    public TestProblem3(double e) {
        this.e = e;
        double[] y0 = new double[]{1.0 - e, 0.0, 0.0, FastMath.sqrt((double)((1.0 + e) / (1.0 - e)))};
        this.setInitialConditions(0.0, y0);
        this.setFinalConditions(20.0);
        double[] errorScale = new double[]{1.0, 1.0, 1.0, 1.0};
        this.setErrorScale(errorScale);
        this.y = new double[y0.length];
    }

    public TestProblem3() {
        this(0.1);
    }

    public void doComputeDerivatives(double t, double[] y, double[] yDot) {
        double r2 = y[0] * y[0] + y[1] * y[1];
        double invR3 = 1.0 / (r2 * FastMath.sqrt((double)r2));
        yDot[0] = y[2];
        yDot[1] = y[3];
        yDot[2] = -invR3 * y[0];
        yDot[3] = -invR3 * y[1];
    }

    public double[] computeTheoreticalState(double t) {
        double E = t;
        double d = 0.0;
        double corr = 999.0;
        for (int i = 0; i < 50 && FastMath.abs((double)corr) > 1.0E-12; ++i) {
            double f2 = this.e * FastMath.sin((double)E);
            double f0 = d - f2;
            double f1 = 1.0 - this.e * FastMath.cos((double)E);
            double f12 = f1 + f1;
            corr = f0 * f12 / (f1 * f12 - f0 * f2);
            E = t + (d -= corr);
        }
        double cosE = FastMath.cos((double)E);
        double sinE = FastMath.sin((double)E);
        this.y[0] = cosE - this.e;
        this.y[1] = FastMath.sqrt((double)(1.0 - this.e * this.e)) * sinE;
        this.y[2] = -sinE / (1.0 - this.e * cosE);
        this.y[3] = FastMath.sqrt((double)(1.0 - this.e * this.e)) * cosE / (1.0 - this.e * cosE);
        return this.y;
    }
}

