/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.DoublePoint;
import org.apache.commons.math3.ml.clustering.KMeansPlusPlusClusterer;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KMeansPlusPlusClustererTest {
    private RandomGenerator random;

    @Before
    public void setUp() {
        this.random = new JDKRandomGenerator();
        this.random.setSeed(1746432956321L);
    }

    @Test
    public void testPerformClusterAnalysisDegenerate() {
        KMeansPlusPlusClusterer transformer = new KMeansPlusPlusClusterer(1, 1);
        DoublePoint[] points = new DoublePoint[]{new DoublePoint(new int[]{1959, 325100}), new DoublePoint(new int[]{1960, 373200})};
        List clusters = transformer.cluster(Arrays.asList(points));
        Assert.assertEquals((long)1L, (long)clusters.size());
        Assert.assertEquals((long)2L, (long)((Cluster)clusters.get(0)).getPoints().size());
        DoublePoint pt1 = new DoublePoint(new int[]{1959, 325100});
        DoublePoint pt2 = new DoublePoint(new int[]{1960, 373200});
        Assert.assertTrue((boolean)((Cluster)clusters.get(0)).getPoints().contains(pt1));
        Assert.assertTrue((boolean)((Cluster)clusters.get(0)).getPoints().contains(pt2));
    }

    @Test
    public void testCertainSpace() {
        KMeansPlusPlusClusterer.EmptyClusterStrategy[] strategies;
        for (KMeansPlusPlusClusterer.EmptyClusterStrategy strategy : strategies = new KMeansPlusPlusClusterer.EmptyClusterStrategy[]{KMeansPlusPlusClusterer.EmptyClusterStrategy.LARGEST_VARIANCE, KMeansPlusPlusClusterer.EmptyClusterStrategy.LARGEST_POINTS_NUMBER, KMeansPlusPlusClusterer.EmptyClusterStrategy.FARTHEST_POINT}) {
            int numberOfVariables = 27;
            int position1 = 1;
            int position2 = position1 + numberOfVariables;
            int position3 = position2 + numberOfVariables;
            int position4 = position3 + numberOfVariables;
            int multiplier = 1000000;
            DoublePoint[] breakingPoints = new DoublePoint[numberOfVariables];
            for (int i = 0; i < numberOfVariables; ++i) {
                DoublePoint DoublePoint2;
                int[] points = new int[]{position1, position2, position3, position4};
                int j = 0;
                while (j < points.length) {
                    int n = j++;
                    points[n] = points[n] * multiplier;
                }
                breakingPoints[i] = DoublePoint2 = new DoublePoint(points);
                position1 += numberOfVariables;
                position2 += numberOfVariables;
                position3 += numberOfVariables;
                position4 += numberOfVariables;
            }
            for (int n = 2; n < 27; ++n) {
                KMeansPlusPlusClusterer transformer = new KMeansPlusPlusClusterer(n, 100, (DistanceMeasure)new EuclideanDistance(), this.random, strategy);
                List clusters = transformer.cluster(Arrays.asList(breakingPoints));
                Assert.assertEquals((long)n, (long)clusters.size());
                int sum = 0;
                for (Cluster cluster : clusters) {
                    sum += cluster.getPoints().size();
                }
                Assert.assertEquals((long)numberOfVariables, (long)sum);
            }
        }
    }

    @Test
    public void testSmallDistances() {
        int[] repeatedArray = new int[]{0};
        int[] uniqueArray = new int[]{1};
        DoublePoint repeatedPoint = new DoublePoint(repeatedArray);
        DoublePoint uniquePoint = new DoublePoint(uniqueArray);
        ArrayList<DoublePoint> points = new ArrayList<DoublePoint>();
        int NUM_REPEATED_POINTS = 10000;
        for (int i = 0; i < 10000; ++i) {
            points.add(repeatedPoint);
        }
        points.add(uniquePoint);
        long RANDOM_SEED = 0L;
        int NUM_CLUSTERS = 2;
        boolean NUM_ITERATIONS = false;
        this.random.setSeed(0L);
        KMeansPlusPlusClusterer clusterer = new KMeansPlusPlusClusterer(2, 0, (DistanceMeasure)new CloseDistance(), this.random);
        List clusters = clusterer.cluster(points);
        boolean uniquePointIsCenter = false;
        for (CentroidCluster cluster : clusters) {
            if (!cluster.getCenter().equals(uniquePoint)) continue;
            uniquePointIsCenter = true;
        }
        Assert.assertTrue((boolean)uniquePointIsCenter);
    }

    @Test(expected=NumberIsTooSmallException.class)
    public void testPerformClusterAnalysisToManyClusters() {
        KMeansPlusPlusClusterer transformer = new KMeansPlusPlusClusterer(3, 1, (DistanceMeasure)new EuclideanDistance(), this.random);
        DoublePoint[] points = new DoublePoint[]{new DoublePoint(new int[]{1959, 325100}), new DoublePoint(new int[]{1960, 373200})};
        transformer.cluster(Arrays.asList(points));
    }

    private class CloseDistance
    extends EuclideanDistance {
        private static final long serialVersionUID = 1L;

        private CloseDistance() {
        }

        public double compute(double[] a, double[] b) {
            return super.compute(a, b) * 0.001;
        }
    }
}

