/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RectangularCholeskyDecomposition;
import org.junit.Assert;
import org.junit.Test;

public class RectangularCholeskyDecompositionTest {
    @Test
    public void testDecomposition3x3() {
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 9.0, 9.0}, {9.0, 225.0, 225.0}, {9.0, 225.0, 625.0}});
        RectangularCholeskyDecomposition d = new RectangularCholeskyDecomposition(m, 1.0E-6);
        Assert.assertEquals((double)0.8, (double)d.getRootMatrix().getEntry(0, 2), (double)1.0E-15);
        Assert.assertEquals((double)25.0, (double)d.getRootMatrix().getEntry(2, 0), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)d.getRootMatrix().getEntry(2, 2), (double)1.0E-15);
        RealMatrix root = d.getRootMatrix();
        RealMatrix rebuiltM = root.multiply(root.transpose());
        Assert.assertEquals((double)0.0, (double)m.subtract(rebuiltM).getNorm(), (double)1.0E-15);
    }

    @Test
    public void testFullRank() {
        RealMatrix base = MatrixUtils.createRealMatrix((double[][])new double[][]{{0.1159548705, 0.0, 0.0, 0.0}, {0.0896442724, 0.1223540781, 0.0, 0.0}, {0.0852155322, 0.004558668, 0.1083577299, 0.0}, {0.0905486674, 0.0213768077, 0.0128878333, 0.1014155693}});
        RealMatrix m = base.multiply(base.transpose());
        RectangularCholeskyDecomposition d = new RectangularCholeskyDecomposition(m, 1.0E-10);
        RealMatrix root = d.getRootMatrix();
        RealMatrix rebuiltM = root.multiply(root.transpose());
        Assert.assertEquals((double)0.0, (double)m.subtract(rebuiltM).getNorm(), (double)1.0E-15);
        Assert.assertTrue((root.subtract(base).getNorm() > 0.3 ? 1 : 0) != 0);
    }

    @Test
    public void testMath789() {
        RealMatrix m1 = MatrixUtils.createRealMatrix((double[][])new double[][]{{0.013445532, 0.01039469, 0.009881156, 0.010499559}, {0.01039469, 0.023006616, 0.008196856, 0.010732709}, {0.009881156, 0.008196856, 0.019023866, 0.009210099}, {0.010499559, 0.010732709, 0.009210099, 0.019107243}});
        this.composeAndTest(m1, 4);
        RealMatrix m2 = MatrixUtils.createRealMatrix((double[][])new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.013445532, 0.01039469, 0.009881156, 0.010499559}, {0.0, 0.01039469, 0.023006616, 0.008196856, 0.010732709}, {0.0, 0.009881156, 0.008196856, 0.019023866, 0.009210099}, {0.0, 0.010499559, 0.010732709, 0.009210099, 0.019107243}});
        this.composeAndTest(m2, 4);
        RealMatrix m3 = MatrixUtils.createRealMatrix((double[][])new double[][]{{0.013445532, 0.01039469, 0.0, 0.009881156, 0.010499559}, {0.01039469, 0.023006616, 0.0, 0.008196856, 0.010732709}, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.009881156, 0.008196856, 0.0, 0.019023866, 0.009210099}, {0.010499559, 0.010732709, 0.0, 0.009210099, 0.019107243}});
        this.composeAndTest(m3, 4);
    }

    private void composeAndTest(RealMatrix m, int expectedRank) {
        RectangularCholeskyDecomposition r = new RectangularCholeskyDecomposition(m);
        Assert.assertEquals((long)expectedRank, (long)r.getRank());
        RealMatrix root = r.getRootMatrix();
        RealMatrix rebuiltMatrix = root.multiply(root.transpose());
        Assert.assertEquals((double)0.0, (double)m.subtract(rebuiltMatrix).getNorm(), (double)1.0E-16);
    }
}

