/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.ConstantRealDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.RealDistributionAbstractTest;
import org.junit.Assert;
import org.junit.Test;

public class ConstantRealDistributionTest
extends RealDistributionAbstractTest {
    public void setUp() {
        super.setUp();
        this.setTolerance(0.0);
    }

    public ConstantRealDistribution makeDistribution() {
        return new ConstantRealDistribution(1.0);
    }

    public double[] makeCumulativeTestPoints() {
        return new double[]{0.0, 0.5, 1.0};
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.0, 0.0, 1.0};
    }

    public double[] makeDensityTestValues() {
        return new double[]{0.0, 0.0, 1.0};
    }

    @Test
    public void testInverseCumulativeProbabilities() {
        RealDistribution dist = this.getDistribution();
        for (double x : this.getCumulativeTestValues()) {
            Assert.assertEquals((double)1.0, (double)dist.inverseCumulativeProbability(x), (double)0.0);
        }
    }

    @Test
    public void testMeanVariance() {
        ConstantRealDistribution dist = new ConstantRealDistribution(-1.0);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)-1.0, (double)0.0);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)0.0, (double)0.0);
    }

    @Test
    public void testSampling() {
        ConstantRealDistribution dist = new ConstantRealDistribution(0.0);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((double)0.0, (double)dist.sample(), (double)0.0);
        }
    }
}

