/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax.util;

import java.io.Serializable;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InMemoryLRUResourceCache<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int CACHE_SIZE = 255;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int CACHE_CAPACITY = (int)Math.ceil(340.0) + 1;
    private final Map<URL, V> data = new LinkedHashMap<URL, V>(CACHE_CAPACITY, 0.75f){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<URL, V> eldest) {
            return this.size() > 255;
        }
    };

    public boolean containsKey(URL key) {
        InMemoryLRUResourceCache.checkKey(key);
        return this.data.containsKey(key);
    }

    public V get(URL key) {
        InMemoryLRUResourceCache.checkKey(key);
        return this.data.get(key);
    }

    public void put(URL key, V value) {
        InMemoryLRUResourceCache.checkKey(key);
        this.data.put(key, value);
    }

    private static void checkKey(URL key) {
        if (key == null) {
            throw new IllegalArgumentException("null keys not supported");
        }
    }
}

