/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax.builder;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Map;
import org.apache.cocoon.pipeline.Pipeline;
import org.apache.cocoon.pipeline.builder.LinkedPipelineConfigurationBuilder;
import org.apache.cocoon.pipeline.builder.LinkedPipelineSetupBuilder;
import org.apache.cocoon.pipeline.component.PipelineComponent;
import org.apache.cocoon.sax.SAXPipelineComponent;
import org.apache.cocoon.sax.builder.LinkedSAXPipelineComponentBuilder;
import org.apache.cocoon.sax.component.CleaningTransformer;
import org.apache.cocoon.sax.component.IncludeTransformer;
import org.apache.cocoon.sax.component.LogAsXMLTransformer;
import org.apache.cocoon.sax.component.LogTransformer;
import org.apache.cocoon.sax.component.SchemaProcessorTransformer;
import org.apache.cocoon.sax.component.XIncludeTransformer;
import org.apache.cocoon.sax.component.XMLSerializer;
import org.apache.cocoon.sax.component.XSLTTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LinkedSAXPipelineComponentBuilderImpl
implements LinkedSAXPipelineComponentBuilder {
    private final Pipeline<SAXPipelineComponent> pipeline;

    public LinkedSAXPipelineComponentBuilderImpl(Pipeline<SAXPipelineComponent> pipeline) {
        this.pipeline = pipeline;
    }

    @Override
    public LinkedSAXPipelineComponentBuilder addCleaningTransformer() {
        return this.addComponent(new CleaningTransformer());
    }

    @Override
    public LinkedSAXPipelineComponentBuilder addIncludeTransformer() {
        return this.addComponent(new IncludeTransformer());
    }

    @Override
    public LinkedSAXPipelineComponentBuilder addLogAsXMLTransformer() {
        return this.addComponent(new LogAsXMLTransformer());
    }

    @Override
    public LinkedSAXPipelineComponentBuilder addLogAsXMLTransformer(File logFile) {
        if (logFile == null) {
            throw new IllegalArgumentException("Parameter 'logFile' must be not null");
        }
        return this.addComponent(new LogAsXMLTransformer(logFile));
    }

    @Override
    public LinkedSAXPipelineComponentBuilder addLogTransformer(File logFile) throws IOException {
        return this.addLogTransformer(logFile, false);
    }

    @Override
    public LinkedSAXPipelineComponentBuilder addLogTransformer(File logFile, boolean append) throws IOException {
        return this.addLogTransformer(logFile, append, "yyyy-MM-dd'T'hh:mm:ss");
    }

    @Override
    public LinkedSAXPipelineComponentBuilder addLogTransformer(File logFile, boolean append, String datePattern) throws IOException {
        if (datePattern == null) {
            throw new IllegalArgumentException("Parameter 'datePattern' must be not null");
        }
        return this.addLogTransformer(logFile, append, new SimpleDateFormat(datePattern));
    }

    @Override
    public LinkedSAXPipelineComponentBuilder addLogTransformer(File logFile, boolean append, SimpleDateFormat dateFormat) throws IOException {
        if (logFile == null) {
            throw new IllegalArgumentException("Parameter 'logFile' must be not null");
        }
        if (dateFormat == null) {
            throw new IllegalArgumentException("Parameter 'dateFormat' must be not null");
        }
        return this.addComponent(new LogTransformer(logFile, append, dateFormat));
    }

    @Override
    public LinkedSAXPipelineComponentBuilder addSchemaProcessorTransformer(URL source) {
        if (source == null) {
            throw new IllegalArgumentException("Parameter 'source' must be not null");
        }
        return this.addComponent(new SchemaProcessorTransformer(source));
    }

    @Override
    public LinkedSAXPipelineComponentBuilder addXIncludeTransformer() {
        return this.addXIncludeTransformer(null);
    }

    @Override
    public LinkedSAXPipelineComponentBuilder addXIncludeTransformer(URL baseUrl) {
        return this.addComponent(new XIncludeTransformer(baseUrl));
    }

    @Override
    public LinkedSAXPipelineComponentBuilder addXSLTTransformer(URL source) {
        return this.addXSLTTransformer(source, null);
    }

    @Override
    public LinkedSAXPipelineComponentBuilder addXSLTTransformer(URL source, Map<String, Object> attributes) {
        if (source == null) {
            throw new IllegalArgumentException("Parameter 'source' must be not null");
        }
        return this.addComponent(new XSLTTransformer(source, attributes));
    }

    @Override
    public <SPC extends SAXPipelineComponent> LinkedSAXPipelineComponentBuilder addComponent(SPC pipelineComponent) {
        if (pipelineComponent == null) {
            throw new IllegalArgumentException("Parameter 'pipelineComponent' must not be null");
        }
        this.pipeline.addComponent(pipelineComponent);
        return this;
    }

    @Override
    public LinkedPipelineConfigurationBuilder<SAXPipelineComponent> addSerializer() {
        this.pipeline.addComponent((PipelineComponent)new XMLSerializer());
        return new LinkedPipelineConfigurationBuilder<SAXPipelineComponent>(){

            public LinkedPipelineSetupBuilder<SAXPipelineComponent> withEmptyConfiguration() {
                return this.setConfiguration(Collections.EMPTY_MAP);
            }

            public LinkedPipelineSetupBuilder<SAXPipelineComponent> setConfiguration(Map<String, ? extends Object> parameters) {
                if (parameters == null) {
                    throw new IllegalArgumentException("Parameter 'parameters' must be not null");
                }
                LinkedSAXPipelineComponentBuilderImpl.this.pipeline.setConfiguration(parameters);
                return new LinkedPipelineSetupBuilder<SAXPipelineComponent>(){

                    public Pipeline<SAXPipelineComponent> setup(OutputStream outputStream) {
                        if (outputStream == null) {
                            throw new IllegalArgumentException("Parameter 'outputStream' must be not null");
                        }
                        LinkedSAXPipelineComponentBuilderImpl.this.pipeline.setup(outputStream);
                        return LinkedSAXPipelineComponentBuilderImpl.this.pipeline;
                    }
                };
            }
        };
    }
}

