/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class URLConnectionUtils {
    private static final Log LOG = LogFactory.getLog(URLConnectionUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeQuietly(URLConnection urlConnection) {
        if (urlConnection == null) {
            return;
        }
        if (urlConnection.getDoInput()) {
            InputStream inputStream = null;
            try {
                inputStream = urlConnection.getInputStream();
            }
            catch (IOException e) {
                LOG.warn((Object)("Can't close input stream from " + urlConnection.getURL()), (Throwable)e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Can't close input stream from " + urlConnection.getURL()), (Throwable)e);
                    }
                }
            }
        }
        if (urlConnection.getDoOutput()) {
            OutputStream outputStream = null;
            try {
                outputStream = urlConnection.getOutputStream();
            }
            catch (IOException e) {
                LOG.warn((Object)("Can't close output stream to " + urlConnection.getURL()), (Throwable)e);
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Can't close input stream to " + urlConnection.getURL()), (Throwable)e);
                    }
                }
            }
        }
    }
}

