/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline.caching;

import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.cocoon.pipeline.caching.AbstractCacheKey;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.util.MurmurHashCodeBuilder;
import org.apache.cocoon.pipeline.util.StringRepresentation;

public class TimestampCacheKey
extends AbstractCacheKey {
    private static final long serialVersionUID = 1L;
    private final long timestamp;
    private final URL url;

    public TimestampCacheKey(URL url, long timestamp) {
        this.url = url;
        this.timestamp = timestamp;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimestampCacheKey)) {
            return false;
        }
        TimestampCacheKey other = (TimestampCacheKey)obj;
        return this.url.equals(other.url);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getLastModified() {
        return this.getTimestamp();
    }

    public int hashCode() {
        return new MurmurHashCodeBuilder().append(this.url.toExternalForm()).append(this.timestamp).toHashCode();
    }

    public boolean isValid(CacheKey cacheKey) {
        if (!this.equals(cacheKey)) {
            return false;
        }
        TimestampCacheKey other = (TimestampCacheKey)cacheKey;
        return this.timestamp == other.timestamp;
    }

    public String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        return StringRepresentation.buildString(this, "url=" + this.url, "timestamp=" + this.timestamp + " (" + dateFormat.format(new Date(this.timestamp)) + ")");
    }
}

